% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/group.R, R/DataFrame.R
\docType{methods}
\name{gapply}
\alias{gapply}
\alias{gapply}
\alias{gapply,GroupedData-method}
\alias{gapply}
\alias{gapply,SparkDataFrame-method}
\title{gapply}
\usage{
gapply(x, ...)

\S4method{gapply}{GroupedData}(x, func, schema)

\S4method{gapply}{SparkDataFrame}(x, cols, func, schema)
}
\arguments{
\item{x}{a SparkDataFrame or GroupedData.}

\item{...}{additional argument(s) passed to the method.}

\item{func}{a function to be applied to each group partition specified by grouping
column of the SparkDataFrame. The function \code{func} takes as argument
a key - grouping columns and a data frame - a local R data.frame.
The output of \code{func} is a local R data.frame.}

\item{schema}{the schema of the resulting SparkDataFrame after the function is applied.
The schema must match to output of \code{func}. It has to be defined for each
output column with preferred output column name and corresponding data type.}

\item{cols}{grouping columns.}
}
\value{
A SparkDataFrame.
}
\description{
gapply

Groups the SparkDataFrame using the specified columns and applies the R function to each
group.
}
\note{
gapply(GroupedData) since 2.0.0

gapply(SparkDataFrame) since 2.0.0
}
\examples{

\dontrun{
Computes the arithmetic mean of the second column by grouping
on the first and third columns. Output the grouping values and the average.

df <- createDataFrame (
list(list(1L, 1, "1", 0.1), list(1L, 2, "1", 0.2), list(3L, 3, "3", 0.3)),
  c("a", "b", "c", "d"))

Here our output contains three columns, the key which is a combination of two
columns with data types integer and string and the mean which is a double.
schema <-  structType(structField("a", "integer"), structField("c", "string"),
  structField("avg", "double"))
result <- gapply(
  df,
  c("a", "c"),
  function(key, x) {
    y <- data.frame(key, mean(x$b), stringsAsFactors = FALSE)
}, schema)

We can also group the data and afterwards call gapply on GroupedData.
For Example:
gdf <- group_by(df, "a", "c")
result <- gapply(
  gdf,
  function(key, x) {
    y <- data.frame(key, mean(x$b), stringsAsFactors = FALSE)
}, schema)
collect(result)

Result
------
a c avg
3 3 3.0
1 1 1.5

Fits linear models on iris dataset by grouping on the 'Species' column and
using 'Sepal_Length' as a target variable, 'Sepal_Width', 'Petal_Length'
and 'Petal_Width' as training features.

df <- createDataFrame (iris)
schema <- structType(structField("(Intercept)", "double"),
  structField("Sepal_Width", "double"),structField("Petal_Length", "double"),
  structField("Petal_Width", "double"))
df1 <- gapply(
  df,
  df$"Species",
  function(key, x) {
    m <- suppressWarnings(lm(Sepal_Length ~
    Sepal_Width + Petal_Length + Petal_Width, x))
    data.frame(t(coef(m)))
  }, schema)
collect(df1)

Result
---------
Model  (Intercept)  Sepal_Width  Petal_Length  Petal_Width
1        0.699883    0.3303370    0.9455356    -0.1697527
2        1.895540    0.3868576    0.9083370    -0.6792238
3        2.351890    0.6548350    0.2375602     0.2521257

}
}
\seealso{
\link{gapplyCollect}

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{attach}},
  \code{\link{cache}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{randomSplit}},
  \code{\link{rbind}}, \code{\link{registerTempTable}},
  \code{\link{rename}}, \code{\link{repartition}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{select}}, \code{\link{showDF}},
  \code{\link{show}}, \code{\link{storageLevel}},
  \code{\link{str}}, \code{\link{subset}},
  \code{\link{take}}, \code{\link{union}},
  \code{\link{unpersist}}, \code{\link{withColumn}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.text}}
}
