% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{rbind}
\alias{rbind}
\alias{rbind}
\alias{rbind,SparkDataFrame-method}
\title{Union two or more SparkDataFrames}
\usage{
rbind(..., deparse.level = 1)

\S4method{rbind}{SparkDataFrame}(x, ..., deparse.level = 1)
}
\arguments{
\item{...}{additional SparkDataFrame(s).}

\item{deparse.level}{currently not used (put here to match the signature of
the base implementation).}

\item{x}{a SparkDataFrame.}
}
\value{
A SparkDataFrame containing the result of the union.
}
\description{
Union two or more SparkDataFrames. This is equivalent to \code{UNION ALL} in SQL.
}
\details{
Note: This does not remove duplicate rows across the two SparkDataFrames.
}
\note{
rbind since 1.5.0
}
\examples{
\dontrun{
sparkR.session()
unions <- rbind(df, df2, df3, df4)
}
}
\seealso{
\link{union}

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{attach}},
  \code{\link{cache}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{randomSplit}},
  \code{\link{registerTempTable}}, \code{\link{rename}},
  \code{\link{repartition}}, \code{\link{sample}},
  \code{\link{saveAsTable}}, \code{\link{schema}},
  \code{\link{selectExpr}}, \code{\link{select}},
  \code{\link{showDF}}, \code{\link{show}},
  \code{\link{storageLevel}}, \code{\link{str}},
  \code{\link{subset}}, \code{\link{take}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{with}},
  \code{\link{write.df}}, \code{\link{write.jdbc}},
  \code{\link{write.json}}, \code{\link{write.orc}},
  \code{\link{write.parquet}}, \code{\link{write.text}}
}
