% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{regexp_extract}
\alias{regexp_extract}
\alias{regexp_extract}
\alias{regexp_extract,Column,character,numeric-method}
\title{regexp_extract}
\usage{
regexp_extract(x, pattern, idx)

\S4method{regexp_extract}{Column,character,numeric}(x, pattern, idx)
}
\arguments{
\item{x}{a string Column.}

\item{pattern}{a regular expression.}

\item{idx}{a group index.}
}
\description{
Extract a specific \code{idx} group identified by a Java regex, from the specified string column.
If the regex did not match, or the specified group did not match, an empty string is returned.
}
\note{
regexp_extract since 1.5.0
}
\examples{
\dontrun{regexp_extract(df$c, '(\\d+)-(\\d+)', 1)}
}
\seealso{
Other string_funcs: \code{\link{ascii}},
  \code{\link{base64}}, \code{\link{concat_ws}},
  \code{\link{concat}}, \code{\link{decode}},
  \code{\link{encode}}, \code{\link{format_number}},
  \code{\link{format_string}}, \code{\link{initcap}},
  \code{\link{instr}}, \code{\link{length}},
  \code{\link{levenshtein}}, \code{\link{locate}},
  \code{\link{lower}}, \code{\link{lpad}},
  \code{\link{ltrim}}, \code{\link{regexp_replace}},
  \code{\link{reverse}}, \code{\link{rpad}},
  \code{\link{rtrim}}, \code{\link{soundex}},
  \code{\link{substring_index}}, \code{\link{translate}},
  \code{\link{trim}}, \code{\link{unbase64}},
  \code{\link{upper}}
}
