% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/WindowSpec.R
\name{rowsBetween}
\alias{rowsBetween}
\alias{rowsBetween,WindowSpec,numeric,numeric-method}
\title{rowsBetween}
\usage{
rowsBetween(x, start, end)

\S4method{rowsBetween}{WindowSpec,numeric,numeric}(x, start, end)
}
\arguments{
\item{x}{a WindowSpec}

\item{start}{boundary start, inclusive.
The frame is unbounded if this is the minimum long value.}

\item{end}{boundary end, inclusive.
The frame is unbounded if this is the maximum long value.}
}
\value{
a WindowSpec
}
\description{
Defines the frame boundaries, from \code{start} (inclusive) to \code{end} (inclusive).
}
\details{
Both \code{start} and \code{end} are relative positions from the current row. For example,
"0" means "current row", while "-1" means the row before the current row, and "5" means the
fifth row after the current row.
}
\note{
rowsBetween since 2.0.0
}
\examples{
\dontrun{
  rowsBetween(ws, 0, 3)
}
}
\seealso{
Other windowspec_method: 
\code{\link{orderBy}()},
\code{\link{partitionBy}()},
\code{\link{rangeBetween}()}
}
\concept{windowspec_method}
