% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batty_karlstrom_entropy.R
\name{plot_areapart}
\alias{plot_areapart}
\title{Plot area partition.}
\usage{
plot_areapart(data.assign, win, is.pointdata = FALSE, add.data = FALSE,
  data.bin = FALSE, category = NULL, data, G.coords = NULL, main = "",
  ribbon = TRUE)
}
\arguments{
\item{data.assign}{A three column matrix, containing the data coordinates (centroids, when pixels)
and the id of the corresponding sub-area.
Provided by user or returned by \code{\link[=areapart]{areapart()}}.}

\item{win}{The observation area, an object of class \code{owin} (see package \code{spatstat}).}

\item{is.pointdata}{Logical: \code{T} if data are a point pattern, \code{F} if they are pixels.}

\item{add.data}{Logical: \code{F} (default) if only the area partition is plotted, \code{T} if
data are added to the area partition plot.}

\item{data.bin}{Logical, only used when \code{add.data=TRUE}: \code{T} (default) if
the plot displays the dichotomized version of the dataset, according to the category of interest.}

\item{category}{A character string. The exact name of the category of interest for Batty's
or Karlstrom and Ceccato's spatial entropy, as in \code{data}.
Only used when \code{add.data=TRUE} and \code{data.bin=TRUE}.}

\item{data}{A data matrix for lattice data, or a \code{ppp} object for point data (see package \code{spatstat}).}

\item{G.coords}{A two column matrix with the coordinates of the sub-areas centroids.
Only needed if \code{data} is a point pattern.}

\item{main}{Optional, a character string with the plot main title.}

\item{ribbon}{Logical, whether to display a ribbon showing the colour map.}
}
\value{
A plot of the partition in sub-areas, according to the chosen options.
}
\description{
This function plots an area partition into sub-areas,
generated by \code{\link[=areapart]{areapart()}}.
}
\details{
This function allows to plot a fixed or randomly generated area partition,
such as the one produced by \code{\link[=areapart]{areapart()}}. The plot changes according
to a few options: the partition may be plotted with or without data,
with or without colour filling. When data present multiple categories,
one can choose to plot the category of interest together with the
partition. If the data are points, the Dirichlet tessellation
is plotted (see \code{dirichlet} in the package \code{spatstat}).
If the data are pixels, the partition follows the pixel borders.
}
\examples{
#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
ccc=coords_pix(area=square(10), nrow=10, ncol=10)
partition=areapart(square(10), G=5, data.coords=ccc)
#plot without data
plot_areapart(partition$data.assign, square(10), is.pointdata=FALSE,
add.data=FALSE, data=data.lat, G.coords=partition$G.coords, main="")
#plot with data
plot_areapart(partition$data.assign, square(10), is.pointdata=FALSE,
add.data=TRUE, data=data.lat, G.coords=partition$G.coords, main="")
#plot with data - dichotomize data according to a category of interest
plot_areapart(partition$data.assign, square(10), is.pointdata=FALSE,
add.data=TRUE, data.bin=TRUE, category="a",
data=data.lat, G.coords=partition$G.coords, main="")

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
ccc=coords(data.pp)
partition=areapart(square(10), G=4, data.coords=ccc)
#plot without data
plot_areapart(partition$data.assign, square(10), is.pointdata=TRUE,
add.data=FALSE, data=data.pp, G.coords=partition$G.coords, main="")
#plot with data
plot_areapart(partition$data.assign, square(10), is.pointdata=TRUE,
add.data=TRUE, data=data.pp, G.coords=partition$G.coords, main="")
#plot with data - dichotomize data according to a category of interest
plot_areapart(partition$data.assign, square(10), is.pointdata=TRUE,
add.data=TRUE, data.bin=TRUE, category="a",
data=data.pp, G.coords=partition$G.coords, main="")

}
