% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannonX_sq}
\alias{shannonX_sq}
\title{Shannon's entropy with a squared information function.}
\usage{
shannonX_sq(data)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is the mark vector.}
}
\value{
Estimated probabilities for all data categories, and Shannon's entropy of \eqn{X} with a squared
information function.
}
\description{
This function computes Shannon's entropy of \eqn{X} with the square of the information function.
}
\details{
This computes a version of Shannon's entropy (see \code{\link[=shannonX]{shannonX()}}) where
the information function \eqn{\log(1/p(x_i))} is squared:
\deqn{H(X)_2=\sum p(x_i) \log(1/p(x_i))^2}
It is useful for estimating the
variance of the maximum likelihood estimator of Shannon's entropy given by
\code{\link[=shannonX]{shannonX()}}.
}
\examples{
#NON SPATIAL DATA
shannonX_sq(sample(1:5, 50, replace=TRUE))

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
shannonX_sq(marks(data.pp))

#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
shannonX_sq(data.lat)

}
