% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatMCA.R
\name{plot.spatmca}
\alias{plot.spatmca}
\title{Display the cross-validation results}
\usage{
\method{plot}{spatmca}(x, ...)
}
\arguments{
\item{x}{An spatmca class object for \code{plot} method}

\item{...}{Not used directly}
}
\value{
\code{NULL}
}
\description{
Display the M-fold cross-validation results
}
\examples{
p <- q <- 5
n <- 50
x1 <- matrix(seq(-7, 7, length = p), nrow = p, ncol = 1)
x2 <- matrix(seq(-7, 7, length = q), nrow = q, ncol = 1)
u <- exp(-x1^2) / norm(exp(-x1^2), "F")
v <- exp(-(x2 - 2)^2) / norm(exp(-(x2 - 2)^2), "F")
Sigma <- array(0, c(p + q, p + q))
Sigma[1:p, 1:p] <- diag(p)
Sigma[(p + 1):(p + q), (p + 1):(p + q)] <- diag(p)
Sigma[1:p, (p + 1):(p + q)] <- u \%*\% t(v)
Sigma[(p + 1):(p + q), 1:p] <- t(Sigma[1:p, (p + 1):(p + q)])
noise <- MASS::mvrnorm(n, mu = rep(0, p + q), Sigma = 0.001 * diag(p + q))
Y <- MASS::mvrnorm(n, mu = rep(0, p + q), Sigma = Sigma) + noise
Y1 <- Y[, 1:p]
Y2 <- Y[, -(1:p)]
cv_1D <- spatmca(x1, x2, Y1, Y2, num_cores = 2)
plot(cv_1D)
}
\seealso{
\link{spatmca}
}
