% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{distErrorPlot}
\alias{distErrorPlot}
\title{Generate box or violin plots showing error distribution}
\usage{
distErrorPlot(
  object,
  error,
  colors,
  x.by = "pBin",
  facet.by = NULL,
  color.by = "nCellTypes",
  filter.sc = TRUE,
  error.label = FALSE,
  pos.x.label = 4.6,
  pos.y.label = NULL,
  size.point = 0.1,
  alpha.point = 1,
  type = "violinplot",
  ylimit = NULL,
  nrow = NULL,
  ncol = NULL,
  title = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with
\code{trained.model} slot containing metrics in the
\code{test.deconv.metrics} slot of a \code{\linkS4class{DeconvDLModel}}
object.}

\item{error}{Error to be represented. Available metric errors are: absolute
error (\code{'AbsErr'}), proportional absolute error (\code{'ppAbsErr'}),
squared error (\code{'SqrErr'}), and proportional squared error
(\code{'ppSqrErr'}).}

\item{colors}{Vector of colors to be used.}

\item{x.by}{Variable used for the X-axis. When \code{facet.by} is not
\code{NULL}, the best choice is \code{pBin} (probability bins). Options:
\code{nCellTypes} (number of different cell types), \code{CellType} (cell
type), and \code{pBin}.}

\item{facet.by}{Show data in different panels. Options are \code{nCellTypes}
(number of different cell types) and \code{CellType} (cell type)
(\code{NULL} by default).}

\item{color.by}{Variable used to color data. Options are \code{nCellTypes}
and \code{CellType}.}

\item{filter.sc}{Boolean indicating whether single-cell profiles are filtered
out and only mixed transcriptional profile errors are shown (\code{TRUE} by
default).}

\item{error.label}{Boolean indicating whether to show the average error as a
plot annotation (\code{FALSE} by default).}

\item{pos.x.label}{X-axis position of error annotations.}

\item{pos.y.label}{Y-axis position of error annotations.}

\item{size.point}{Size of points (0.1 by default).}

\item{alpha.point}{Alpha of points (0.1 by default).}

\item{type}{Type of plot: \code{'boxplot'} or \code{'violinplot'} (the latter
by default).}

\item{ylimit}{Upper limit in Y-axis if it is required (\code{NULL} by
default).}

\item{nrow}{Number of rows if \code{facet.by} is not \code{NULL}.}

\item{ncol}{Number of columns if \code{facet.by} is not \code{NULL}.}

\item{title}{Title of the plot.}

\item{theme}{\pkg{ggplot2} theme.}

\item{...}{Additional arguments for the \link[ggplot2]{facet_wrap} function
of \pkg{ggplot2} if \code{facet.by} is not \code{NULL}.}
}
\value{
A ggplot object.
}
\description{
Generate box or violin plots to show how errors are distributed. Errors can
be shown all mixed or either split by cell type (\code{CellType}) or number
of cell types present in the spots (\code{nCellTypes}). See the
\code{facet.by} argument and examples for more details.
}
\examples{
\donttest{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(
      x = paste0("CellType", seq(6)), size = 20, replace = TRUE
    )
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE
)
SDDLS <- genMixedCellProp(
  object = SDDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  num.sim.spots = 50,
  train.freq.cells = 2/3,
  train.freq.spots = 2/3,
  verbose = TRUE
)
SDDLS <- simMixedProfiles(SDDLS)
# training of DDLS model
SDDLS <- trainDeconvModel(
  object = SDDLS,
  batch.size = 15,
  num.epochs = 5
)
# evaluation using test data
SDDLS <- calculateEvalMetrics(object = SDDLS)
# representation, for more examples, see the vignettes
distErrorPlot(
  object = SDDLS,
  error = "AbsErr",
  facet.by = "CellType",
  color.by = "nCellTypes",
  error.label = TRUE
)
distErrorPlot(
  object = SDDLS,
  error = "AbsErr",
  x.by = "CellType",
  facet.by = NULL,
  color.by = "CellType",
  error.label = TRUE
)
}

}
\seealso{
\code{\link{calculateEvalMetrics}} \code{\link{corrExpPredPlot}}
\code{\link{blandAltmanLehPlot}} \code{\link{barErrorPlot}}
}
