\name{latlong2grid}
\alias{latlong2grid}
\title{Convert Coordinates from Latitude/Longitude to Grid}
\description{
Convert geographic latitude/longitude coordinates to kilometer-based grid coordinates.  
}
\usage{
latlong2grid(input)
}
\arguments{
  \item{input}{either an \code{n x 2} matrix of longitude and latitude coordinates in decimal format or an object of class SpatialPolygons (See \link[sp]{SpatialPolygons-class})}
}
\note{ 
Rough conversion of US lat/long to km (used by GeoBUGS):  (see also forum.swarthmore.edu/dr.math/problems/longandlat.html).  Radius of earth: r = 3963.34 (equatorial) or 3949.99 (polar) mi = 6378.2 or 6356.7 km, which implies: km per mile  = 1.609299 or 1.609295 a change of 1 degree of latitude corresponds to the same number of km, regardless of longitude.  arclength=r*theta, so the multiplier for coord\$y should probably be just the radius of earth.
On the other hand, a change of 1 degree in longitude corresponds to a different distance, depending on latitude.  (at N pole, the change is essentially 0.  at the equator, use equatorial radius.
}
\details{
Longitude/latitudes are not a grid-based coordinate system:  latitudes are equidistant but the distance between longitudes varies.
}
\value{
Either a data frame with the corresponding (x,y) kilometer-based grid coordinates, or a SpatialPolygons object with the coordinates changed.
}
\author{Lance A. Waller}
\examples{
## Convert coordinates
coord <- data.frame(rbind(
# Montreal, QC:  Latitude: 45deg 28' 0" N (deg min sec), Longitude: 73deg 45' 0" W
c(-73.7500, 45.4667),
# Vancouver, BC:  Latitude: 45deg 39' 38" N (deg min sec), Longitude: 122deg 36' 15" W
c(-122.6042, 45.6605)
))
latlong2grid(coord)

## Convert SpatialPolygon
data(pennLC)
new <- latlong2grid(pennLC$spatial.polygon)
par(mfrow=c(1,2))
plot(pennLC$spatial.polygon,axes=TRUE)
title("Lat/Long")
plot(new,axes=TRUE)
title("Grid (in km)")
}
\keyword{file}
