% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickStewart.R
\name{quickStewart}
\alias{quickStewart}
\title{Create a SpatialPolygonsDataFrame of Potentials Contours}
\usage{
quickStewart(spdf, df, spdfid = NULL, dfid = NULL, var, var2 = NULL,
  typefct = "exponential", span, beta, resolution = NULL, mask = NULL,
  nclass = 8, breaks = NULL)
}
\arguments{
\item{spdf}{a SpatialPolygonsDataFrame.}

\item{df}{a data frame that contains the values to compute}

\item{spdfid}{name of the identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{dfid}{name of the identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the numeric field in df used to compute potentials.}

\item{var2}{name of the numeric field in df used to compute potentials. 
This field is used for ratio computation (see Details).}

\item{typefct}{character; spatial interaction function. Options are "pareto" 
(means power law) or "exponential".
If "pareto" the interaction is defined as: (1 + alpha * mDistance) ^ (-beta).
If "exponential" the interaction is defined as: 
exp(- alpha * mDistance ^ beta).
The alpha parameter is computed from parameters given by the user 
(\code{beta} and \code{span}).}

\item{span}{numeric; distance where the density of probability of the spatial 
interaction function equals 0.5.}

\item{beta}{numeric; impedance factor for the spatial interaction function.}

\item{resolution}{numeric; resolution of the output SpatialPointsDataFrame
(in map units).}

\item{mask}{SpatialPolygonsDataFrame; mask used to clip contours of potentials.}

\item{nclass}{numeric; a targeted number of classes (default to 8). Not used if breaks is set.}

\item{breaks}{numeric; a vector of values used to discretize the potentials.}
}
\value{
A SpatialPolygonsDataFrame is returned (see \link{rasterToContourPoly} Value).
}
\description{
This function is a wrapper around \link{stewart}, \link{rasterStewart} 
and \link{rasterToContourPoly} functions. 
Providing only the main parameters of these functions, it simplifies a lot the computation of potentials. 
This function creates a SpatialPolygonsDataFrame of potential values. 
It also allows to compute directly the ratio between the potentials of two variables.
}
\details{
If var2 is provided the ratio between the potentials of var (numerator) 
and var2 (denominator) is computed.
}
\examples{
# load data
data("spatData")
# Compute a SpatialPolygonsDataFrame of potentials
pot.spdf <- quickStewart(spdf = spatPts, 
                         df = spatPts@data, 
                         var = "Capacite", 
                         span = 1000, 
                         beta = 2, mask = spatMask)
plot(pot.spdf)
# cartography
if(require("cartography")){
  breaks <- sort(c(unique(pot.spdf$min), max(pot.spdf$max)), decreasing = FALSE)
  cartography::choroLayer(spdf = pot.spdf, df = pot.spdf@data,
                          var = "center", breaks = breaks, 
                          legend.pos = "topleft",
                          legend.title.txt = "Nb. of Beds")
}
pot.spdf@data


# Compute a SpatialPolygonsDataFrame of a ratio of potentials
spatPts$dummy <- spatPts$Capacite + c(rep(50, 18))
pot2.spdf <- quickStewart(spdf = spatPts, 
                          df = spatPts@data, 
                          var = "Capacite", 
                          var2 = "dummy",
                          span = 1000, 
                          beta = 2, mask = spatMask)
# cartography
if(require("cartography")){
  breaks <- sort(c(unique(pot2.spdf$min), max(pot2.spdf$max)), decreasing = FALSE)
  cartography::choroLayer(spdf = pot2.spdf, df = pot2.spdf@data,
                          var = "center", breaks = breaks, 
                          legend.pos = "topleft",legend.values.rnd = 3,
                          legend.title.txt = "Nb. of Beds")
}
}
\seealso{
\link{stewart}, \link{rasterStewart}, \link{plotStewart}, 
\link{rasterToContourPoly}, \link{CreateGrid}, \link{CreateDistMatrix}.
}

