% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridandmat.R
\name{CreateDistMatrix}
\alias{CreateDistMatrix}
\title{Create a Distance Matrix Between Two Spatial Objects}
\usage{
CreateDistMatrix(knownpts, unknownpts, bypassctrl = FALSE, longlat = TRUE)
}
\arguments{
\item{knownpts}{sp or sf object; rows of the distance matrix.}

\item{unknownpts}{sp or sf object; columns of the distance matrix.}

\item{bypassctrl}{logical; bypass the distance matrix size control (see Details).}

\item{longlat}{logical; if FALSE, Euclidean distance, if TRUE Great Circle 
(WGS84 ellipsoid) distance.}
}
\value{
A distance matrix, row names are \code{knownpts} row names, column 
names are \code{unknownpts} row names.
}
\description{
This function creates a distance matrix between two 
spatial objects (sp or sf objects).
}
\details{
The function returns a full matrix of distances in meters. 
If the matrix to compute is too large (more than 100,000,000 cells, more than 
10,000,000 origins or more than 10,000,000 destinations) 
the function sends a confirmation message to warn users about the amount of 
RAM mobilized. 
Use \code{bypassctrl} = TRUE to skip this control.
}
\examples{
# Create a grid of paris extent and 200 meters
# resolution
data(hospital)
mygrid <- CreateGrid(w = paris, resolution = 200)
# Create a distance matrix between known hospital and mygrid
mymat <- CreateDistMatrix(knownpts = hospital, unknownpts = mygrid)
mymat[1:5,1:5]
nrow(paris)
nrow(mygrid)
dim(mymat)
}
\seealso{
\link{CreateGrid}
}
