% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stprod.R
\name{stprod}
\alias{stprod}
\title{Standardize a symmetric matrix (distances) to fixed row (column) products.}
\usage{
stprod(mat, vec, differ, niter)
}
\arguments{
\item{mat}{A distance matrix size NxN.}

\item{vec}{A vector of row (column) constraints.}

\item{differ}{A scalar with the maximum accepted difference with the constraint.}

\item{niter}{An integer with the maximum number of iterations.}
}
\value{
Return a distance matrix constrained size NxN.
}
\description{
\code{stprod} standardizes the distance matrix to fixed rows and columns products to use \code{\link{pwd}}.
The function iteratively constrains a logarithmic transformed matrix to know products, and in order to keep the simmetry of the matrix, at each iteration performs an average with its transpose.
When the known products are all equal to a constant (e.g. 1), this method provides a simple and accurate way to scale a distance matrix to a doubly stochastic matrix. The new matrix will not be affected by problems arising from units with different inclusion probabilities, due to not required features of the spatial distribution of the population, such as edge effects and isolated points.
}
\examples{
dis<-as.matrix(dist(cbind(simul1$x,simul1$y))) #distance matrix
vec<-rep(1,nrow(dis)) #vector of constraints
stand_dist<-stsum(dis,vec,1e-15,1000) #standardized matrix
}
\references{
\insertRef{BIMJ:BIMJ1785}{Spbsampling}
}
