% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/exportUtils.R
\name{genWeightMat}
\alias{genWeightMat}
\title{Generate weight matrix}
\usage{
genWeightMat(ages, years, clip = 0, zeroCohorts = NULL)
}
\arguments{
\item{ages}{vector of ages.}

\item{years}{vector of years.}

\item{clip}{number of cohorts in the boundary to assign a zero
weight. This can be be used to zero weigh some of the first and
last cohorts in the data.}

\item{zeroCohorts}{other cohort for which a zero weight is to be assigned.}
}
\value{
A 0-1 matrix with 0 for the zero-weighed cohorts.
}
\description{
Generates a weight matrix given a group of ages and years
and a set of cohorts which are to be given zero weight. This
is useful for excluding some data points when fitting a
Stochastic Mortality Model (see \code{\link{fit.StMoMo}}).
}
\examples{
#Zero-weight the first three and last three cohorts
wxt1 <- genWeightMat(55:89,  EWMaleData$years, clip = 3)
APCfit1 <- fit(apc(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext,
               ages = EWMaleData$ages, years = EWMaleData$years,
               ages.fit = 55:89, wxt = wxt1)
plot(APCfit1, parametricbx = FALSE, nCol = 3)

#Also Zero-weight the 1886 cohort
wxt2 <- genWeightMat(55:89,  EWMaleData$years, clip = 3,
                     zeroCohorts = 1886)
APCfit2 <- fit(apc(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext,
               ages = EWMaleData$ages, years = EWMaleData$years,
               ages.fit = 55:89, wxt = wxt2)
plot(APCfit2, parametricbx = FALSE, nCol = 3)
}
\seealso{
\code{\link{fit.StMoMo}}
}

