% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/independence.test.R
\name{independence.test}
\alias{independence.test}
\title{Nonparametric Rank Tests for Independence}
\usage{
independence.test(X1, X2, method = c("spearman", "kendall"))
}
\arguments{
\item{X1}{a vector, using NA to stand for the missing ranks}

\item{X2}{the same as X1}

\item{method}{whether the test is based on Spearman correlation or Kendall
correlation}
}
\value{
a list of the test statistics
}
\description{
This function performs a nonparametric test of ranking data based
on the correlation. This function can be applied to the ranking data
with missing ranks and tie ranks.
}
\examples{
Arith = c(14, 18, 23, 26, 27, 30, 40, NA, NA)
Lang = c(28, 14, 46, NA, 53, NA, 54, 50, NA)
independence.test(Arith, Lang, method = "spearman")
independence.test(Arith, Lang, method = "kendall")
}
\author{
Li Qinglong <liqinglong0830@163.com>
}
\references{
Rank Correlation Methods for Missing Data, Mayer Alvo and Paul
Cablio \cr
Nonparametric Rank Tests for Independence in Opinion Surveys, Philip L.H. Yu,
K.F. Lam, and Mayer Alvo
}

