% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{RandEff_to_alpha012}
\alias{RandEff_to_alpha012}
\title{Correlation structure: transform random effects to alpha}
\usage{
RandEff_to_alpha012(sigResid, tau, gamma, psi)
}
\arguments{
\item{sigResid}{Residual standard deviation on individual leve}

\item{tau}{standard deviation of random cluster intercept}

\item{gamma}{standard deviation of random time effect}

\item{psi}{standard deviation of random subject specific intercept}
}
\value{
a list containing four named elements (possibly matrices):
`alpha0`, `alpha1`, `alpha2` specify a correlation structure and SigMarg
denotes the marginal standard deviation
}
\description{
Correlation structure: transform random effects to alpha
}
\examples{
RandEff_to_alpha012(sigResid=sqrt(11), tau=4, gamma=3, psi=2)

## The function is vectorised:
RandEff_to_alpha012(sigResid = matrix(c(0,1,2,3,4,5), 2, 3),
                    tau      = matrix(c(1,1,1,0,0,0), 2, 3),
                    gamma    = matrix(c(0,0,1,0,0,1), 2, 3),
                    psi      = matrix(c(0,1,1,0,0,1), 2, 3))
}
