% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_usm_xl.R
\name{download_usm_csv}
\alias{download_usm_csv}
\title{Downloading a CSV usms data file example into a directory}
\usage{
download_usm_csv(
  file = NULL,
  out_dir = tempdir(),
  stics_version = "latest",
  overwrite = FALSE,
  verbose = FALSE,
  csv_name = lifecycle::deprecated(),
  version_name = lifecycle::deprecated(),
  dest_dir = lifecycle::deprecated()
)
}
\arguments{
\item{file}{Name of a csv file (optional, not used for the moment)}

\item{out_dir}{Directory path where to copy the csv file
(default: \code{tempdir()})}

\item{stics_version}{Name of the STICS version. Optional, by default
the latest version returned by get_stics_versions_compat() is used.}

\item{overwrite}{Optional logical, TRUE for overwriting files,
FALSE otherwise (default)}

\item{verbose}{Logical value for displaying information while running}

\item{csv_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{csv_name} is no
longer supported, use file instead.}

\item{version_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{version_name} is no
longer supported, use stics_version instead.}

\item{dest_dir}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{dest_dir} is no
longer supported, use out_dir instead.}
}
\value{
A vector of copied files path.
}
\description{
The file is an example that can be used for generating JavaSTICS
usms.xml input file from parameters values stored in a CSV file using
the function \code{\link{gen_usms_xml}}
}
\examples{
download_usm_csv(out_dir = tempdir())

}
