% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_day_number.R
\name{compute_day_from_date}
\alias{compute_day_from_date}
\title{Convert date into day number}
\usage{
compute_day_from_date(date, start_date)
}
\arguments{
\item{date}{date vector you wish to convert,
in the \code{\link[base]{Date}} format}

\item{start_date}{date used as the reference point,
in the \code{\link[base]{Date}} format, typically the simulation start year}
}
\value{
numeric vector
}
\description{
Computes the day number corresponding to a given date (or vector of)
with reference to a start date.
Typically, the start date should be the date at which a STICS simulation
will start. Leap years are properly handled.
}
\examples{
start_date <- as.Date("2014-08-01")
date <- as.Date("2015-02-10")
compute_day_from_date(date=date, start_date=start_date)

start_date <- as.Date("2008-08-01")
date <- as.Date("2009-02-10")
compute_day_from_date(date=date, start_date=start_date)
}
\author{
Timothee Flutre
}
