% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tauLeapingStochKit2RInterface}
\alias{tauLeapingStochKit2RInterface}
\title{C++ Interface to Explicit Adaptive Tau-Leaping simulation}
\usage{
tauLeapingStochKit2RInterface(StochKit2Rmodel, outputDirNameString, time,
  realizations, intervals, keepStats, keepTrajectories, keepHistograms, bins,
  seed, p, epsilon, threshold)
}
\arguments{
\item{StochKit2Rmodel}{R list (Rcpp List built from buildStochKit2Rmodel output)}

\item{outputDirNameString}{Character string with path to output directory. Should end in path separator.}

\item{time}{Simulation time of each realization}

\item{realizations}{Number of realizations}

\item{intervals}{Number of output intervals. Default 0 outputs at end time only. 1=keep data at start and end time, 2=keep data at start, middle, and end times, etc. Note data is stored at (intervals+1) equally spaced time points.}

\item{keepStats}{Keep means and variances data}

\item{keepTrajectories}{Keep trajectory data}

\item{keepHistograms}{Keep histogram data}

\item{bins}{Number of histogram bins}

\item{seed}{Seed for random number generator}

\item{p}{Override default and specify the number of processes (threads) to use. By default (=0), the number of processes will be determined automatically}

\item{epsilon}{Set the tolerance (applicable to tauLeaping only), default is 0.03. Valid values: must be greater than 0.0 and less than 1.0}

\item{threshold}{Set the threshold (minimum number of reactions per leap before switching to ssa) for tauLeaping}
}
\description{
\code{ssa} Called by StochKit2R tauLeaping function, do not call this C++ interface directly
}
\keyword{internal}

