% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_get_parmdoc.R
\name{e2e_get_parmdoc}
\alias{e2e_get_parmdoc}
\title{Get documentation on the parameters in the model.}
\usage{
e2e_get_parmdoc(id = 9)
}
\arguments{
\item{id}{Integer value denoting the class of parameters details to be downloaded. Choose from: 0 = fitted ecology, 1 = fixed ecology, 2 = fishing fleet, 3 = harvest ratios, 4 = environmental drivers, 5 = physical configuration, 9 = all (default = 9).}
}
\value{
dataframe of parameter documentation.
}
\description{
Provides access to documentation on the parameters in the model in the form of a dataframe.
}
\details{
The full range of inputs to the model includes both numeric values which are constant over the during a run, and values which vary over time during a run according to an externally provided schedule. We refer to the latter as 'drivers', but they are all parameters nontheless.
The constant parameters are divided into categories according to whether they are associated with the ecology model, the fishing fleet model, and whether they are available for optimization or not.

This function downloads documentation on the full range of parameters in the form of a dataframe which can be used to form labels in user-generated code. The parameters are identified by a numeric value linked to 6 different classes of parameter.

Note that the function does not supply the numeric values of parameters for any given model setup. These are available in the model definition object generated by the function e2e_read().
}
\examples{
    parm_list <- e2e_get_parmdoc(0)    # Get documentation on the fitted ecology parameters       
    parm_list <- e2e_get_parmdoc(9)    # Get documentation all parameters
    parm_list <- e2e_get_parmdoc()     # Get documentation all parameters

}
\seealso{
\code{\link{e2e_read}}
}
