% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changesvg.R
\name{changesvg}
\alias{changesvg}
\title{Changes a pointsvg object}
\usage{
changesvg(object, forget = NULL, front = NULL, back = NULL,
  standard = FALSE, keep.ratio = F, round = FALSE, xdigits = 4,
  ydigits = 4, xinverse = FALSE, yinverse = FALSE)
}
\arguments{
\item{object}{a pointsvg object (svg object imported as data frame
using \code{\link{pointsvg}}).}

\item{forget}{the elements that should be discarded, by their id
or index (i.e. name or number of appearance).}

\item{front, back}{the elements to be put in front and back position,
by their id or index (i.e. name or number of appearance). By default the
order is the one of the original .svg file.}

\item{standard}{whether to standardise (centre to (0,0), rescale so
that extreme points are at -1 and 1) or not (T or F)}

\item{keep.ratio}{if the object is to be  standardised, whether to
keep the x/y ratio (T or F)}

\item{round}{whether to round the coordinates or not (T or F)}

\item{xdigits}{the number of digits after the decimal to round to for
x values}

\item{ydigits}{the number of digits after the decimal to round to for
y values}

\item{xinverse}{whether to inverse the plotting for x values (T or F)}

\item{yinverse}{whether to inverse the plotting for y values (T or F)}
}
\value{
A data.frame with x and y coordinates, ids for each object, and a
type, either line (L) or polygon (P)
}
\description{
Changes a svg object imported as data frame using
\code{\link{pointsvg}}.
}
\examples{
object1 <- example.lense

opar <- par("mfrow")
par(mfrow = c(1,3))

plot(c(-1,1), c(-1,1), type = "n")
placesvg(object1)

plot(c(-1,1), c(-1,1), type = "n")
object2 <- changesvg(object1, forget = 1)
placesvg(object2)

plot(c(-1,1), c(-1,1), type = "n")
object3 <- changesvg(object1, forget = "P1", standard = TRUE)
placesvg(object3)

par(mfrow = opar)

}
\seealso{
Importing .svg objects: \code{\link{pointsvg}}

Plot the drawing and change the coordinates :\code{\link{placesvg}},
\code{\link{centresvg}} and \code{\link{framesvg}}

Clip the drawing: \code{\link{clipsvg}}
}
