% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/placesvg.R
\name{placesvg}
\alias{placesvg}
\title{Draws a pointsvg object}
\usage{
placesvg(
  object,
  forget = NULL,
  front = NULL,
  back = NULL,
  standard = FALSE,
  keep.ratio = FALSE,
  col = NA,
  border = "black",
  density = NULL,
  angle = 45,
  lwd = par("lwd"),
  lty = par("lty"),
  scol = border,
  slty = lty,
  slwd = lwd
)
}
\arguments{
\item{object}{a pointsvg object (svg object imported as data frame
using \code{\link{pointsvg}}).}

\item{forget}{the elements that should be discarded, by their id
or index (i.e. name or number of appearance).}

\item{front, back}{the elements to be put in front and back position,
by their id or index (i.e. name or number of appearance). By default the
order is the one of the original .svg file.}

\item{standard}{whether to standardise (centre to (0,0), rescale so
that extreme points are at -1 and 1) or not (T or F)}

\item{keep.ratio}{if the object is to be  standardised, whether to
keep the x/y ratio (T or F)}

\item{col}{the polygones background color. If density is specified with
a positive value this gives the color of the shading lines.}

\item{border}{the lines color.}

\item{density}{the density of shading lines, in lines per inch. The
default value of NULL means that no shading lines are drawn.}

\item{angle}{the slope of shading lines, given as an angle in degrees
(counter-clockwise)}

\item{lty, lwd}{the border line type and width, see ?par for details.}

\item{scol, slty, slwd}{the colour, type and width of the shading lines.}
}
\description{
Draws a svg object imported as data frame using
\code{\link{pointsvg}}, with its importation coordinates (or with
standardisation).
}
\examples{
object <- example.ammonite

plot(c(-2,2), c(-2,2), type = "n")

placesvg(object, lty = 1,density = 20, angle = 45)

}
\seealso{
\code{\link{centresvg}} and \code{\link{framesvg}}
}
