% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weldlog.R
\name{weldlog}
\alias{weldlog}
\title{Changes boundaries segments in basic lithologs}
\usage{
weldlog(
  log,
  dt,
  seg,
  j = 1:length(dt),
  col.xy = 1,
  col.dt = 2,
  auto.dt = T,
  add.dt = 0,
  omit1 = NULL,
  omit2 = NULL,
  warn = T,
  tolerance = 8
)
}
\arguments{
\item{log}{a "litholog()"-like data frame on which the new segments
need to be welded.}

\item{dt}{the position of the n boundaries to change.}

\item{seg}{a list of n dataframes having xy and dt coordinates for
the segments that are going to be welded to the log.}

\item{j}{the indexes of the segments attributed to each boundary or
the names of these segments. Should be of same length than dt.}

\item{col.xy}{the number of the column for the xy coordinates in the
seg dataframes.}

\item{col.dt}{the number of the column for the dt coordinates in the
seg dataframes.}

\item{auto.dt}{whether to automatically add the dt value to the dt of
the segments (with the add.dt value when it is not zero)}

\item{add.dt}{a value to add to the dt of the segments for each
boundary (in addition of the value of the \code{dt} parameter). Should be of
length 1 or of same length than dt.}

\item{omit1, omit2}{the dt of the boundary for which either the upper
or lower bed should not be welded to (1 and 2 depending on the order of the
beds in the original log)}

\item{warn}{whether you want to be annoyed (beginners should find it
useful to be annoyed)}

\item{tolerance}{the order of tolerance for errors, i.e. the number of
decimals considered as being meaningful for matching dt to log}
}
\value{
a "litholog()"-like data frame, with new bed boundaries
}
\description{
Adds personalised segements to bed boundaries of lithologs from
"litholog()"-like data frames
}
\examples{
l <- c(0,1,2,3,4)
r <- c(1,2,3,4,5)
h   <- c(4,3,4,3,4)
i <- c("B1","B2","B3","B4","B5")
log  <- litholog(l, r, h, i)

whiteSet(xlim = c(-1,5), ylim = c(-1,6))

multigons(log$i, log$xy, log$dt, lty = 3)

seg1 <- sinpoint(4, 0, 0.25, phase=0.5)
seg2 <- sinpoint(4, 0, 0.25, phase=1.5)

welded <- weldlog(log, dt = c(2,3,4), seg = list(seg1 = seg1, seg2 = seg2),
                  j = c("seg1", "seg2", "seg2"))

multigons(welded$i, welded$xy, welded$dt, lwd = 3, lty = 2, border = "red")

}
\seealso{
Complementary function\code{\link{litholog}}

Underlying function: \code{\link{weld}}

To generate sinuoisidal segments: \code{\link{sinpoint}}
To generate a lot of different sinuoisidal segments: see the example in
\code{\link{neatPick}}

To import and adapt .svg files as segments: \code{\link{pointsvg}},
\code{\link{framesvg}}, \code{\link{centresvg}} and \code{\link{changesvg}}
}
