% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changejoint.R
\name{changejoint}
\alias{changejoint}
\title{Change the dimensions of bedding joints}
\usage{
changejoint(
  joint,
  yinv = F,
  xinv = F,
  yleft = NA,
  yright = NA,
  ymin = NA,
  ymax = NA,
  xmin = NA,
  xmax = NA
)
}
\arguments{
\item{joint}{the bedding joint to be modified}

\item{yinv, xinv}{whether to inverse the plotting for x and y values (T or F)}

\item{yleft, yright}{the depth/height/time value for the extreme point at the
right or left of the joint (yleft overruns yright, which overruns ymin and
ymax)}

\item{ymin, ymax}{the extreme values for the y axis (in case of conflict with
yleft and/or yright, defaults to the smallest exaggeration)}

\item{xmin, xmax}{the extreme values for the x axis}
}
\description{
Change the dimensions of bedding joints
}
\examples{
# Create an initial litholog ----

l <- c(-2,-1,0,1,2)
r <- c(-1,0,1,2,3)
h   <- c(4,3,4,3,4)
i <- c("B1","B2","B3","B4","B5")
log  <- litholog(l, r, h, i)

# Get a custom bedding joint to specific dimensions using changejoint() ----

liq <- changejoint(oufti99$liquefaction,
                   yleft = 0, ymax = 0.3,
                   xmin = 1, xmax = 2)

nlog <- weldlog(log, dt = 0, seg = list(liq = liq), j = c("liq"))

# Plots for visualisation ----

plot.new()
plot.window(xlim = c(0,5), ylim = c(-2,3))

axis(1)
axis(2)

multigons(nlog$i, nlog$xy, nlog$dt)

}
