% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.lim.R
\name{trace.lim}
\alias{trace.lim}
\alias{plot_lim}
\title{Visualize lim objects}
\usage{
trace.lim(
  lim = NULL,
  l = NULL,
  r = NULL,
  id = 1L,
  b = "[]",
  xy = 0,
  order = F,
  decreasingly = F,
  output = T,
  plot = T,
  link = F,
  point = T,
  style = list(),
  close = list(pch = 19),
  open = list(pch = 21, bg = "white"),
  add = F,
  gen = list(xlab = "dt", ylab = "xy")
)

plot_lim(
  dt,
  xy,
  int,
  include,
  link = F,
  point = T,
  style = list(),
  close = list(pch = 19),
  open = list(pch = 21, bg = "white"),
  add = F,
  gen = list(xlab = "dt", ylab = "xy")
)
}
\arguments{
\item{lim}{a list of n left (1st element) and n right (2ndt element)
interval limits, of n interval IDs, and of n interval boundary rules (e.g.
"[]").}

\item{l}{the left interval limits (numerical vector of length n).}

\item{r}{the right interval limits (numerical vector of length n).}

\item{id}{the interval IDs (numerical or character vector of length n,
the default is 1 for each interval). They can be similar for different
intervals.}

\item{b}{the interval boundaries rules: "[]"
(or "closed") to include both boundaries points, "][" (or "()" and "open") to
exclude both boundary points, "[[" (or "[)","right-open" and"left-closed") to
include only the left boundary point, and "]]" (or "(]", "left-open",
"right-closed") to include only the right boundary point. The notation is
simplified to "[]", "[[", "]]" and "][" only.}

\item{xy}{the intensity attributed to each interval.}

\item{order}{whether to order the intervals.}

\item{decreasingly}{whether the order to set is decreasing.}

\item{output}{whether to output the results.}

\item{plot}{whether to plot the results.}

\item{link}{whether to link all the intervals into one line.}

\item{point}{whether to add points to the boundaries of each interval.}

\item{style}{the style of the lines.}

\item{close}{the style of the points for closed boundaries.}

\item{open}{the style of the points for open boundaries.}

\item{add}{whether to add the plot to an existing plot.}

\item{gen}{parameters for \code{\link{plot}}}

\item{dt}{the boundaries of the intervals as provided by \code{trace.lim}.}

\item{int}{the id of each interval as provided by \code{trace.lim}.}

\item{include}{whether the boundaries of the intervals are included in them,
as provided by \code{trace.lim}.}
}
\value{
\code{trace.lim} returns a list of 'dt' values (dt stands for
depth/time, which corresponds to the boundaries of intervals), 'xy' values
(the "intensity" of each interval), 'int' which is an id for each interval,
id which is the ids defined in the lim objects (these ids can be similar for
different intervals, and therefore define groups of intervals), and 'include'
which are boolean (T/F) values whether a boundary of the interval is included
in the interval.
}
\description{
Visualize lim objects as lines for each interval. The lines are
time series with the dt (depth/time) being the boundaries of the interval,
and an xy intensity is defined as values attributed to the interval.
}
\examples{
lim <- as.lim(l = c(0,6,4,6,50), r = c(1,5,6,9,8),
              b = c("[[", "]]", "[[", "]]", "[["))

xy <- c(1,2,3,4,5)

trace <- trace.lim(lim = lim, xy = xy, plot = FALSE)

trace

plot_lim(dt = trace$dt, xy = trace$xy,
         int = trace$int, include = trace$include)

}
\seealso{
generalities on lim data: \code{\link{as.lim}}
}
