% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-bar-chart-function-new.r
\name{plot_barchart}
\alias{plot_barchart}
\title{Barchart for subgroup effect size}
\usage{
plot_barchart(
  dat,
  covari.sel,
  trt.sel,
  resp.sel,
  outcome.type,
  font.size = c(15, 12, 10, 0.6),
  title = NULL,
  lab.y = NULL,
  effect = "RMST",
  time = NULL,
  decimals = 0
)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main title; the second element is for the covariates
labels and the y-axis label; the third is for the category labels; the forth is for the unit label of the y axis.}

\item{title}{a string specifying the main title.}

\item{lab.y}{a string specifying the y-axis label.}

\item{effect}{either "HR" or "RMST". only when outcome.type = "survival"}

\item{time}{time for calculating the RMST}

\item{decimals}{decimal places for the axis}
}
\description{
This function produces a bar chart showing the treatment effect size of pairwise subgroups defined by the categories of two
covariates. Also, it prints out the minimum and maximum of the treatment effect size on the console. Note that each bar has a width
which is proportional to the ratio of the corresponding sample size to the full size. In addition, the function uses log odd ratio
and log hazard ratio for displaying subgroup effect sizes in binary and survival data, respectively.
}
\examples{
# # Load the data to be used
data(prca)
dat <- prca
levels(dat$age_group) = c("Young","Middle-aged","Old")
levels(dat$weight_group) = c("Low","Mid","High")
names(dat)[c(14,15)] = c("Age", "Weight")

## 4. Bar chart -----------------------------------------------------------
plot_barchart(dat,
              covari.sel = c(14,15),
              trt.sel = 3,
              resp.sel = c(1, 2),
              outcome.type = "survival",
              font.size = c(14, 12, 14, 0.75), time = 50,
              lab.y = "Treatment effect size (RMST difference)")

}
