% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/24-mosaic-plot-function.r
\name{plot_mosaic}
\alias{plot_mosaic}
\title{Mosaic plot}
\usage{
plot_mosaic(
  dat,
  covari.sel,
  trt.sel,
  resp.sel,
  outcome.type,
  range.v = NULL,
  adj.ann.subgrp = 4,
  range.strip = c(-3, 3),
  n.brk = 30,
  n.brk.axis = NULL,
  font.size = c(1, 1, 0.85, 0.85, 1),
  title = NULL,
  lab.xy = NULL,
  strip = "default",
  effect = "HR",
  lwd. = 2,
  sep. = 0.05,
  show.overall = TRUE,
  palette = "divergent",
  col.power = 0.5,
  print.ss = FALSE,
  col.line = "white",
  time = NULL,
  show.marginal = TRUE,
  show.effect = TRUE,
  grid.newpage = TRUE
)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{range.v}{a vector specifying the vertical range of graphical display.}

\item{adj.ann.subgrp}{a parameter adjusting the distance between a point and its corresponding subgroup label. The smaller the value
is, the larger the distance is.}

\item{range.strip}{range for the treatment effect scale}

\item{n.brk}{number of breaks in the treatment effect scale}

\item{n.brk.axis}{number of breaks in the axis of the treatment effect scale}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main title, the second is for
for x-axis and y-axis labels; the third is for the legend text of subgroups; the fourth is for the subgroup
labels near points; the fifth is for the unit labels on all the axes.}

\item{title}{a string specifying the main title.}

\item{lab.xy}{a list of two strings specifying the labels of the x and y axes.}

\item{strip}{title for the treatment effect scale}

\item{effect}{either "HR" or "RMST". only when outcome.type = "survival"}

\item{lwd.}{line width for the mosaics}

\item{sep.}{separation for the mosaics}

\item{show.overall}{logical. whether to show or not the overall treatment effect in the strip}

\item{palette}{either "divergent" or "hcl"}

\item{col.power}{to be used when palette = "hcl". see colorspace package for reference}

\item{print.ss}{logival indicating whether to show the sample sizes of subgroups}

\item{col.line}{color of the mosaics' border}

\item{time}{time for calculating the RMST}

\item{show.marginal}{logical indicating whether to show the marginal subgroups. only when 2 covariates are used}

\item{show.effect}{logical indicating whether to show effect size using color or not. only when 3 covariates are used}

\item{grid.newpage}{logical. If TRUE (default), the function calls grid::grid.newpage() to start from an empty page.}
}
\description{
This function produces a mosaic plot for subgroup analysis
}
\examples{
library(dplyr)
data(prca)
dat <- prca
dat \%>\%
  mutate(bm = factor(ifelse(bm == 0 , "No", "Yes")),
         hx = factor(ifelse(hx == 0 , "No", "Yes")),
         Treatment = factor(ifelse(rx == 0 , "Control", "Treatment")),
         Survival = factor(ifelse(survtime > 24 , "Yes", "No"),
         levels = c("Yes", "No")))-> dat
levels(dat$age_group) = c("Young","Middle-aged","Old")
levels(dat$weight_group)  = c("Low","Mid","High")
# Change variable names
dat \%>\%
  rename(`Bone Metastasis` = bm,
         `Performance rating` = pf,
         `History of cardiovascular events` = hx,
         `2-year survival` = Survival,
         Weight = weight_group,
         Age = age_group) -> dat
## 2.a Mosaic plot with 2 variables -----------------------------------------
plot_mosaic(dat = dat,
            covari.sel = c(14, 15),
            trt.sel = 3,
            resp.sel = c(1, 2),
            outcome.type =  "survival",
            range.v = NULL,
            adj.ann.subgrp = 4,
            range.strip=c(-3, 3),
            n.brk = 31,
            n.brk.axis = 7, sep. = 0.034,
            font.size = c(10, 10, 10, 10, 0.7),
            title = NULL, lab.xy = NULL,
            strip = "Treatment effect size (log-hazard ratio)",
            col.line = "white", lwd. = 2,
            effect = "HR", print.ss = FALSE, palette = "hcl")

## 2.b Mosaic plot with 3 variables -----------------------------------------
plot_mosaic(dat = dat,
            covari.sel = c(15, 7, 4),
            trt.sel = 3,
            resp.sel = c(1, 2),
            outcome.type =  "survival",
            range.v = NULL, adj.ann.subgrp = 4,
            range.strip=c(-3, 3),
            n.brk = 31, n.brk.axis = 7,
            font.size = c(10, 10, 10, 10, 0.7),
            title = NULL, lab.xy = NULL,
            strip = "Treatment effect size (log-hazard ratio)",
            effect = "HR", palette = "hcl")
}
