% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGlobalGraph.R
\name{plotGlobalGraph}
\alias{plotGlobalGraph}
\title{Plot a global graph of the drug}
\usage{
plotGlobalGraph(
  data,
  drug.label = "",
  overall.main = "",
  overall.cex.main = 1.5,
  cex.submap.axis = 1,
  cex.submap.lab = 1,
  cex.submap.main = 1,
  cex.submap.sub = 1,
  cex.legend = 1
)
}
\arguments{
\item{data}{A list of result data generated by function `PrioSubtypeDrug()`.}

\item{drug.label}{A character string of drug labels to determine which drug to use for visualization.}

\item{overall.main}{An overall title for the whole graph. If the user
does not make any input, the title will display a drug label.}

\item{overall.cex.main}{The magnification to be used for overall.main (default: 1.5).}

\item{cex.submap.axis}{The magnification to be used for axis of each submap annotation relative to
the current setting of cex.}

\item{cex.submap.lab}{The magnification to be used for x and y labels of each submap relative to
the current setting of cex.}

\item{cex.submap.main}{The magnification to be used for main titles of each submap relative to the
current setting of cex.}

\item{cex.submap.sub}{The magnification to be used for sub titles of each submap relative to the
current setting of cex.}

\item{cex.legend}{fontsize of labels for legend.}
}
\value{
A plot.
}
\description{
The `plotGlobalGraph()` identifies the drug label entered by the user, and plots an
integrated diagram including box plot of the normalized drug-disease reverse association scores, null distribution curves
of significant P-value, and heat map of cancer subtype sample distribution.
}
\details{
plotGlobalGraph
}
\examples{
## Get the result data of PrioSubtypeDrug().
## The data is based on the simulated breast cancer subtype data.
Subtype_drugs<-get("Subtype_drugs")
## Plot a global graph of the drug pirenperone(1.02e-05M).
plotGlobalGraph(data=Subtype_drugs,drug.label="pirenperone(1.02e-05M)")
}
\author{
Xudong Han,
Junwei Han,
Chonghui Liu
}
