% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solar-time.r
\name{solar_time}
\alias{solar_time}
\title{Local solar time}
\usage{
solar_time(
  time = lubridate::now(),
  geocode = tibble::tibble(lon = 0, lat = 51.5, address = "Greenwich"),
  unit.out = "time"
)
}
\arguments{
\item{time}{POSIXct Time, any valid time zone (TZ) is allowed, default is
current time.}

\item{geocode}{data frame with variables lon and lat as numeric values
(degrees).}

\item{unit.out}{character string, One of "datetime", "time", "hour", "minute", or
"second".}
}
\value{
In all cases solar time is expressed as time since local astronomical
  midnight and, thus, lacks date information. If \code{unit.out = "time"}, a
  numeric value in seconds with an additional class attribute
  "solar_time"; if \code{unit.out = "datetime"}, a "POSIXct" value in seconds
  from midnight but with an additional class attribute "solar_date"; if
  \code{unit.out = "hour"} or \code{unit.out = "minute"} or \code{unit.out =
  "second"}, a numeric value.
}
\description{
\code{solar_time()} computes the time of day expressed in seconds since the
astronomical midnight using and instant in time and a geocode as input. Solar
time is useful when we want to plot data according to the local solar time
rather than the local time in use at a time zone. How the returned instant in
time is expressed depends on the argument passed to \code{unit.out}.
}
\details{
Solar time is determined by the position of the sun in the sky and
it almost always differs from the time expressed in the local time
coordinates in use. The differences can vary from a few minutes up to a
couple of hours depending on the exact location within the time zone and the
use or not of daylight saving time.
}
\note{
The algorithm is approximate, it calculates the difference between
  local solar noon and noon in the time zone of \code{time} and uses this
  value for the whole day when converting times into solar time. Days are not
  exactly 24 h long. Between successive days the shift is only a few seconds,
  and this leads to a small jump at midnight.
}
\section{Warning!}{
 Returned values are computed based on the time zone of the
  argument for parameter time. In the case of solar time, this timezone does
  not affect the result. However, in the case of solar dates the date part
  may be off by one day, if the time zone does not match the coordinates of
  the geocode value provided as argument.
}

\examples{
BA.geocode <-
  data.frame(lon = -58.38156, lat = -34.60368, address = "Buenos Aires, Argentina")
sol_t <- solar_time(lubridate::dmy_hms("21/06/2016 10:00:00", tz = "UTC"),
                    BA.geocode)
sol_t
class(sol_t)

sol_d <- solar_time(lubridate::dmy_hms("21/06/2016 10:00:00", tz = "UTC"),
                    BA.geocode,
                    unit.out = "datetime")
sol_d
class(sol_d)

}
\seealso{
\code{\link{as_tod}}

Other Local solar time functions: 
\code{\link{as.solar_date}()},
\code{\link{is.solar_time}()},
\code{\link{print.solar_time}()}
}
\concept{Local solar time functions}
