% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-piv_iv_week.R
\name{p_iv.week}
\alias{p_iv.week}
\title{Obtain Psuedo IV Curve and other predicted IV features at reference conditions for
a given week, used internally in IVxbyx function.}
\usage{
p_iv.week(df, temp, N_c, isc_1sun = NULL)
}
\arguments{
\item{df}{A dataframe containing timeseries I-V features of one period.}

\item{temp}{The reference module temperature to correct the Psuedo IV curve to be,
unit of the temperature should be Celsius.}

\item{N_c}{Number of cells in series. Equal to the total number of cells in the system.}

\item{isc_1sun}{(optional) Input an Isc 1-Sun value manually. Leave NULL to have one generated
from the dataframe.}
}
\value{
Psuedo-IV Curve data with features extracted and evaluation parameters
of fitting grouped for a single, given period.
}
\description{
Obtain Psuedo IV Curve and other predicted IV features at reference conditions for
a given week, used internally in IVxbyx function.
}
\examples{
df <- read_df_raw(df_wbw,0.02,7)
df_slice <- dplyr::filter(df, df$n_period == 1)
# Check that this has enough data! needs more than 10 rows to be meaningful
nrow(df_slice)
# needs median temperature
temp <- median_temp(df_wbw)
res <- p_iv.week(df_slice, temp = temp, N_c = 60)


}
