% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_weights_matrix.R
\name{predict_weights_matrix}
\alias{predict_weights_matrix}
\title{Predict Weights of Samples in Terminal Nodes Based on a Survival Tree Fit (Data Supplied as Matrices)}
\usage{
predict_weights_matrix(
  survival_tree,
  matrix_numeric,
  matrix_factor,
  missing = "majority"
)
}
\arguments{
\item{survival_tree}{a fitted survival tree}

\item{matrix_numeric}{numeric predictors, a numeric matrix. 
\code{matrix_numeric[i,j]} is the jth numeric predictor of the ith sample.
The best practice is to have the same column names in the training and testing dataset.}

\item{matrix_factor}{factor predictors, a character matrix. 
\code{matrix_factor[i,j]} is the jth predictor of the ith sample.
The best practice is to have the same column names in the training and testing dataset.}

\item{missing}{a character value that specifies the handling of missing data. 
If \code{missing=="omit"}, samples with missing values in the splitting variables will be discarded.
If \code{missing=="majority"}, samples with missing values in the splitting variables will be assigned to the majority node.
If \code{missing=="weighted"}, samples with missing values in the splitting variables will be weighted by the weights of branch nodes.
The best practice is to use the same method as the trained tree.}
}
\value{
A weight matrix representing the weights of samples in each node.
}
\description{
The function 
\code{predict_weights_matrix} predicts weights of samples in terminal nodes based on a survival tree fit.
}
\details{
Predict Weights of Samples in Terminal Nodes Based on a Survival Tree Fit (Data Supplied as Matrices)
}
\examples{
library(survival)
a_survival_tree<-
  survival_tree_matrix(
    time=lung$time,
    event=lung$status==2,
    matrix_numeric=data.matrix(lung[,c(4,6:9),drop=FALSE]),
    matrix_factor=data.matrix(lung[,5,drop=FALSE]))
a_weight<-
  predict_weights_matrix(
    a_survival_tree,
    matrix_numeric=data.matrix(lung[,c(4,6:9),drop=FALSE]),
    matrix_factor=data.matrix(lung[,5,drop=FALSE]))
}
