% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symplurContentRetweets.R
\name{symplurContentRetweetsTable}
\alias{symplurContentRetweetsTable}
\title{Symplur API - Content/Retweets Table}
\usage{
symplurContentRetweetsTable(query = data.frame(database = character(), start =
  character(), end = character()))
}
\arguments{
\item{query}{A dataframe with columns: database, start and end.}
}
\description{
Creates a dataframe from looping through queries.
}
\details{
Example query dataframe:
\tabular{lll}{
database \tab start \tab end\cr
#BCSM \tab 01/01/2010 \tab 01/01/2018\cr
#LCSM \tab 01/01/2010 \tab 01/01/2018\cr
#BTSM \tab 01/01/2010 \tab 01/01/2018
}
}
\examples{
require(readr)
datasets <- read_csv(system.file("extdata", "datasets.csv", package = "SympluR", mustWork = TRUE))
LCSMDemoDataContentRetweetsTable <- symplurContentRetweetsTable(datasets)
}
\keyword{content}
\keyword{retweets}
\keyword{table}
