% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TBF.R
\name{TBF}
\alias{TBF}
\title{Test-based Bayes factor}
\usage{
TBF(ingredients = NULL, fullModel = NULL, method = "LEB", data = NULL,
  discreteSurv = TRUE, prior = NULL, package = "nnet", maxit = 150)
}
\arguments{
\item{ingredients}{\code{TBF_ingredients_object} ingredients for the TBF
(and g) calculation.}

\item{fullModel}{if \code{ingredients} is \code{NULL}, formula of the model
including all potential variables}

\item{method}{tells us which method for the definition of g should be
used. Possibilities are: \code{LEB}, \code{GEB}, \code{g=n}, \code{hyperG},
\code{ZS}, \code{ZSadapted} and \code{hyperGN}}

\item{data}{the data frame with all the information. Only needed if
\code{ingredients} is \code{NULL}}

\item{discreteSurv}{Boolean variable telling us whether a 'simple'
multinomial regression is looked for or if the goal is a discrete
survival-time model for multiple modes of failure is needed.}

\item{prior}{should a dependent or a flat prior be used on the model space?
Only needed if \code{method = `GEB`}.}

\item{package}{Which package should be used to fit the models; by default
the \code{nnet} package is used; we could also specify to use the package
'VGAM'}

\item{maxit}{Only needs to be specified with package \code{nnet}: maximal
number of iterations}
}
\value{
A list with the TBF and the g (if it is fixed) for all the
candidate models.
}
\description{
This function computes the TBF as well as g
}
\author{
Rachel Heyard
}
