% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen2circles.R
\name{gen2circles}
\alias{gen2circles}
\title{Generate Two Intersecting Circles}
\usage{
gen2circles(n = 496, sd = 0)
}
\arguments{
\item{n}{the total number of observations to be generated.}

\item{sd}{level of additive white noise.}
}
\value{
a list containing\describe{
\item{data}{an \eqn{(n\times 2)} data matrix for row-stacked observations.}
\item{label}{a length-\eqn{n} vector for class label.}
}
}
\description{
It generates data from two intersecting circles.
}
\examples{
## Generate Data with Different Noise Levels
nn = 200
x1 = gen2circles(n=nn, sd=0)
x2 = gen2circles(n=nn, sd=0.1)
x3 = gen2circles(n=nn, sd=0.25)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
plot(x1$data, pch=19, main="sd=0.00", col=x1$label)
plot(x2$data, pch=19, main="sd=0.10", col=x2$label)
plot(x3$data, pch=19, main="sd=0.25", col=x3$label)
par(opar)

}
\concept{data}
