% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unconstrained.R
\name{test_unconstrained}
\alias{test_unconstrained}
\alias{stat_unconstrained}
\alias{translate_evalsofav}
\title{Pivotal bootstrap test of mean eigenvalues}
\usage{
test_unconstrained(x, evals = NULL, evecs = NULL, B = 1000)

stat_unconstrained(x, evals = NULL, evecs = NULL)

translate_evalsofav(x, evals)
}
\arguments{
\item{x}{A single sample of symmetric matrices or multiple samples of symmetric matrices. See \code{\link[=as_flat]{as_flat()}}.}

\item{evals}{When \code{x} is a single sample, the null hypothesis is that the (extrinsic) mean of the population has eigenvalues equal to \code{evals}. For multiple samples \code{evals} must be omitted.}

\item{evecs}{For a single sample, specify eigenvectors to test under the assumption that the population mean's eigenvectors are the columns of \code{evecs}. The order of these eigenvectors matters and should be such that eigenvalues are in descending order.}

\item{B}{Number of bootstrap samples. If \code{B = 'chisq'} then a chi-squared calibration is used instead.}
}
\value{
A \code{TFORGE} object (see \code{\link[=boot_calib]{boot_calib()}} or \code{\link[=chisq_calib]{chisq_calib()}}) with the eigenvalues of the null hypothesis in the \code{null_evals} attribute for \code{t0}.
}
\description{
For a single sample of symmetric matrices, test eigenvalues of the population mean.
For multiple samples of symmetric matrices, test for equality of the eigenvalues of the population means.
Eigenvalues must be distinct.
}
\details{
Test hypotheses described below.
For a single sample, the eigenvectors of the population mean in the null and alternative hypotheses may be prespecified by \code{evecs}.

Bootstrap resampling is conducted from a population that satisfies the null hypothesis by translating each sample in \code{x} with \code{translate_evalsofav()} to so that the sample average has the null eigenvalues.
The test statistic is calculated by \code{stat_unconstrained()}.
}
\section{Hypotheses}{
For a single sample the null hypothesis is that the population (extrinsic) mean has eigenvalues of \code{evals}; the alternative hypothesis is that the eigenvalues are not equal to \code{evals}.
For multiple samples, \code{evals} must be omitted and the null hypothesis is that the population (extrinsic) means have the same eigenvalues.
}

\examples{
test_unconstrained(rsymm_norm(15, diag(c(3,2,1))), evals = c(3, 2, 1), B = 100)
test_unconstrained(list(rsymm_norm(15, diag(c(3,2,1))),
                        rsymm_norm(15, diag(c(3,2,1)))), B = 100)
}
