% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.PWMs.R
\name{as.PWMs}
\alias{as.PWMs}
\alias{as.PWMs.numeric}
\alias{as.PWMs.matrix}
\alias{as.PWMs.list}
\alias{as.PWMs.data.frame}
\title{Convert to PWMs-object}
\usage{
as.PWMs(x, ..., order = NULL)

\method{as.PWMs}{numeric}(x, order = seq_along(x) - 1, ...)

\method{as.PWMs}{matrix}(x, order = row(x)[, 1] - 1, ...)

\method{as.PWMs}{list}(x, order = seq_along(x[[1]]) - 1, ...)

\method{as.PWMs}{data.frame}(x, formula, order = NULL, ...)
}
\arguments{
\item{x}{vector or matrix of PWMs}

\item{...}{additional arguments.}

\item{order}{integer, corresponding order to given PWMs. If NULL, order is
set to 0:(length(x)-1).}

\item{formula}{if \code{x} is data.frame. See examples.}
}
\value{
a PWMs-object, see PWMs-help
}
\description{
Convert vector, matrix, list, or data.frame to a PWMs-object. Note that there is no
calculation of PWMs here. If PWMs should be calculated from data, use PWMs.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: as.PWMs for numeric data vectors

\item \code{matrix}: as.PWMs for numeric data matrices

\item \code{list}: as.PWMs for numeric data lists

\item \code{data.frame}: as.PWMs for numeric data.frames
}}

\examples{
xmat <- cbind(c(0.12, .41, .38, .33), c(.05, 0.28, .25, .22))
xvec <- xmat[, 1]
xlist <- lapply(1:ncol(xmat), function(i) xmat[, i])
xdat <- data.frame(
 station = letters[1:3],
 season = c("S", "W", "S"),
 b0 = c(.12, .15, .05),
 b1 = c(.41, .33, .28),
 b2 = c(.38, .18, .25)
)

as.PWMs(xvec)
as.PWMs(xvec[-2], order = c(0, 2, 3))

as.PWMs(xmat)
as.PWMs(xmat[-2, ], order = c(0, 2, 3))

as.PWMs(xlist)

as.PWMs(xdat, cbind(b0, b1, b2) ~ station)
as.PWMs(xdat, . ~ station + season)
as.PWMs(xdat, cbind(b0, b2) ~ station, order = c(0, 2))

p <- as.PWMs(xdat, cbind(b0, b1, b2) ~ station)
TLMoments(p)

(p <- as.PWMs(xdat, cbind(b0, b1) ~ station))
#parameters(TLMoments(p), "gev") # => error
#parameters(TLMoments(p), "gpd") # => error
parameters(TLMoments(p), "gpd", u = 10)

(p <- as.PWMs(xdat, cbind(b0, b2) ~ station, order = c(0, 2)))
#TLMoments(p) # => error

}
\seealso{
\code{\link{PWMs}}
}
