% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNRS_core.R
\name{TNRS_core}
\alias{TNRS_core}
\title{Handle API access and format}
\usage{
TNRS_core(
  url = "https://tnrsapi.xyz/tnrs_api.php",
  mode = "resolve",
  data_json = NULL,
  sources = c("tropicos", "wcvp"),
  classification = "tropicos",
  matches = "best",
  accuracy = NULL,
  batches = NULL
)
}
\arguments{
\item{url}{Server URL to use.  Defaults to the stable production version}

\item{mode}{Character.  Options are "resolve" and "parse". Default option is "resolve"}

\item{data_json}{Either NULL (the default) or properly formatted json}

\item{sources}{Character. Taxonomic sources to use. Default is c("tropicos","wcvp"). Options include "tropicos", "usda", "wfo", and "wcvp".}

\item{classification}{Character. Family classification to use. Currently options include "tropicos" (the default), which is equivalent to APGIII, and "wfo".}

\item{matches}{Character. Should all matches be returned ("all") or only the best match ("best", the default)?}

\item{accuracy}{numeric.  If specified, only matches with a score greater than or equal to the supplied accuracy level will be returned.}

\item{batches}{NULL or Numeric.  Optional number of batches to divide the request into for parallel processing. CUrrently isn't implemented}

\item{...}{Additional parameters passed to internal functions}
}
\description{
Internal function for handling accessing the API,data formatting, and errors
}
\keyword{internal}
