% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.TOSTt.R
\name{TOSTt-methods}
\alias{TOSTt-methods}
\alias{print.TOSTt}
\alias{plot.TOSTt}
\title{Methods for TOSTt objects}
\usage{
\method{print}{TOSTt}(x, digits = 4, ...)

\method{plot}{TOSTt}(
  x,
  type = c("cd", "c", "tnull"),
  estimates = c("raw", "SMD"),
  ci_lines,
  ci_shades,
  ...
)
}
\arguments{
\item{x}{object of class \code{TOSTt}}

\item{digits}{Number of digits to print for p-values}

\item{...}{further arguments passed through, see description of return value
for details.
\code{\link{TOSTt-methods}}.}

\item{type}{Type of plot to produce. Default is a consonance density plot "cd". Consonance plots (type = "cd") and null distribution plots (type = "tnull") can also be produced. Note: null distribution plots only available for estimates = "raw".}

\item{estimates}{indicator of what estimates to plot; options include "raw" or "SMD". Default is is both: c("raw","SMD").}

\item{ci_lines}{Confidence interval lines for plots. Default is 1-alpha*2 (e.g., alpha = 0.05 is 90\%)}

\item{ci_shades}{Confidence interval shades when plot type is "cd".}
}
\value{
\describe{
  \item{\code{print}}{Prints short summary of the Limits of Agreement}
  \item{\code{plot}}{Returns a plot of the data points used in the reliability analysis}
}
}
\description{
Methods defined for objects returned from the t_TOST and boot_t_TOST functions.
}
