% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pes.R
\name{plot_pes}
\alias{plot_pes}
\title{Function to produce plots of the distribution of partial eta-squared}
\usage{
plot_pes(
  Fstat,
  df1,
  df2,
  type = c("c", "cd"),
  levels = c(0.68, 0.9, 0.95, 0.999)
)
}
\arguments{
\item{Fstat}{The F-statistic from the F-test.}

\item{df1}{Degrees of freedom for the numerator.}

\item{df2}{Degrees of freedom for the denominator.}

\item{type}{Choose whether to plot a "consonance" function ("c"), consonance density ("cd"), or both (c("c","cd"); defualt option).}

\item{levels}{Numeric vector of confidence levels to display}
}
\value{
Returns plot of the distribution of partial eta-squared
}
\description{
Function to produce plots of the distribution of partial eta-squared
}
\details{
This function was created so that users could create consonance plots of partial eta-squared from ANOVA-level effects.
These types of plots are discussed by Schweder T, Hjort NL. (2016, ISBN:9781316445051) and Rafi Z, Greenland S. (2020) <doi:10.1186/s12874-020-01105-9>.
}
\seealso{
Other plotting functions: 
\code{\link{plot_cor}()},
\code{\link{plot_smd}()}
}
\concept{plotting functions}
