% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_rank_plot.R
\name{gene_rank_plot}
\alias{gene_rank_plot}
\title{Gene ranking dotplot for visualizing differentailly expressed genes.}
\usage{
gene_rank_plot(
  data,
  log2fc = 1,
  palette = "Spectral",
  top_n = 10,
  genes_to_label = NULL,
  label_size = 5,
  base_size = 12,
  title = "Gene ranking dotplot",
  xlab = "Ranking of differentially expressed genes",
  ylab = "Log2FoldChange"
)
}
\arguments{
\item{data}{Dataframe: include columns (Genes, Log2FoldChange, Pvalue, Padj), rows (Genes).}

\item{log2fc}{Numeric: log2(FoldChange) cutoff log2(2) = 1. Default: 1.0, min: 0.0, max: null.}

\item{palette}{Character: color palette used for the point. Default: "spectral", options: 'Spectral', 'BrBG', 'PiYG', 'PRGn', 'PuOr', 'RdBu', 'RdGy', 'RdYlBu', 'RdYlGn'.}

\item{top_n}{Numeric: number of top differentailly expressed genes. Default: 10, min: 0.}

\item{genes_to_label}{Character: a vector of selected genes. Default: "NULL".}

\item{label_size}{Numeric: gene label size. Default: 5, min: 0.}

\item{base_size}{Numeric: base font size. Default: 12, min: 0.}

\item{title}{Character: main plot title. Default: "Gene ranking dotplot".}

\item{xlab}{Character: title of the xlab. Default: "Ranking of differentially expressed genes".}

\item{ylab}{Character: title of the ylab. Default: "Log2FoldChange".}
}
\value{
Plot: Gene ranking dotplot for visualizing differentailly expressed genes.
}
\description{
Gene ranking dotplot for visualizing differentailly expressed genes.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset deg_data
data(deg_data)
head(deg_data)

# 3. Default parameters
gene_rank_plot(deg_data)

# 4. Set top_n = 5
gene_rank_plot(deg_data, top_n = 5, palette = "PiYG")

# 5. Set genes_to_label = c("SELL","CCR7","KLRG1","IL7R")
gene_rank_plot(deg_data, genes_to_label = c("SELL","CCR7","KLRG1","IL7R"), palette = "PuOr")

}
\author{
wei dong
}
