% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendro_plot.R
\name{dendro_plot}
\alias{dendro_plot}
\title{Dendrograms for multiple samples/groups clustering.}
\usage{
dendro_plot(
  data,
  dist_method = "euclidean",
  hc_method = "ward.D2",
  tree_type = "rectangle",
  k_num = 5,
  palette = "npg",
  color_labels_by_k = TRUE,
  horiz = FALSE,
  label_size = 1,
  line_width = 1,
  rect = TRUE,
  rect_fill = TRUE,
  xlab = "Samples",
  ylab = "Height",
  ggTheme = "theme_light"
)
}
\arguments{
\item{data}{Dataframe: All genes in all samples expression dataframe of RNA-Seq (1st-col: Genes, 2nd-col~: Samples).}

\item{dist_method}{Character: distance measure method. Default: "euclidean", options: "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{hc_method}{Character: hierarchical clustering method. Default: "ward.D2", options: "ward.D", "ward.D2", "single", "complete","average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}

\item{tree_type}{Character: plot tree type. Default: "rectangle", options: "rectangle", "circular", "phylogenic".}

\item{k_num}{Numeric: the number of groups for cutting the tree. Default: 3.}

\item{palette}{Character: color palette used for the group. Default: "npg", options: "npg", "aaas", "lancet", "jco", "ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{color_labels_by_k}{Logical: labels colored by group. Default: TRUE, options: TRUE or FALSE.}

\item{horiz}{Logical: horizontal dendrogram. Default: FALSE, options: TRUE or FALSE.}

\item{label_size}{Numeric: tree label size. Default: 0.8, min: 0.}

\item{line_width}{Numeric: branches and rectangle line width. Default: 0.7, min: 0.}

\item{rect}{Logical: add a rectangle around groups. Default: TRUE, options: TRUE or FALSE.}

\item{rect_fill}{Logical: fill the rectangle. Default: TRUE, options: TRUE or FALSE.}

\item{xlab}{Character: title of the xlab. Default: "".}

\item{ylab}{Character: title of the ylab. Default: "Height".}

\item{ggTheme}{Character: ggplot2 theme. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void".}
}
\value{
Plot: dendrogram for multiple samples clustering.
}
\description{
Dendrograms for multiple samples/groups clustering.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset gene_expression
data(gene_expression)
head(gene_expression)

# 3. Default parameters
dendro_plot(gene_expression)

# 4. Set palette = "aaas"
dendro_plot(gene_expression, palette = "aaas")

# 5. Set tree_type = "circular"
dendro_plot(gene_expression, tree_type = "circular")

}
\author{
wei dong
}
