adaptp3state <- function(data, varnames) {
	if ( !is.data.frame(data) ) stop("Argument 'data' must be a data.frame")
	if ( !is.character(varnames) | !(length(varnames) == 4) ) stop("Argument 'varnames' must be a character vector with length 4")
	v1 <- which( names(data) == varnames[1] )
	if (length(v1) == 0) stop( paste("Variable name '", varnames[1], "' isn't available in data.frame", sep="") )
	v2 <- which( names(data) == varnames[2] )
	if (length(v2) == 0) stop( paste("Variable name '", varnames[2], "' isn't available in data.frame", sep="") )
	v3 <- which( names(data) == varnames[3] )
	if (length(v3) == 0) stop( paste("Variable name '", varnames[3], "' isn't available in data.frame", sep="") )
	v4 <- which( names(data) == varnames[4] )
	if (length(v4) == 0) stop( paste("Variable name '", varnames[4], "' isn't available in data.frame", sep="") )
	if ( !is.numeric(data[,v1]) ) stop( paste("Variable '", varnames[1], "' must be numeric", sep="") )
	if ( !( is.logical(data[,v2]) | is.numeric(data[,v2]) ) ) stop( paste("Variable '", varnames[2], "' must be logical or numeric", sep="") )
	if ( !is.numeric(data[,v3]) ) stop( paste("Variable '", varnames[3], "' must be numeric", sep="") )
	if ( !( is.logical(data[,v4]) | is.numeric(data[,v4]) ) ) stop( paste("Variable '", varnames[4], "' must be logical or numeric", sep="") )
	if ( any( (data[,v2] != 0 & data[,v2] != 1) | (data[,v2] != FALSE & data[,v2] != TRUE) ) ) stop( paste("Variable '", varnames[2], "' must be 0 or 1 if numeric and TRUE or FALSE if logical", sep="") )
	if ( any( (data[,v4] != 0 & data[,v4] != 1) | (data[,v4] != FALSE & data[,v4] != TRUE) ) ) stop( paste("Variable '", varnames[4], "' must be 0 or 1 if numeric and TRUE or FALSE if logical", sep="") )
	if ( any(data[,v1] < 0 | data[,v3] < 0) ) stop( paste("Variables '", varnames[1], "' and '", varnames[3], "' must be greater than 0", sep="") )
	if ( any(data[,v3] < data[,v1]) ) stop( paste("Variable '", varnames[3], "' must be greater or equal to variable '", varnames[1], "'", sep="") )
	if ( any(!data[,v2] & data[,v3] != data[,v1]) ) stop( paste("Variables '", varnames[3], "' and '", varnames[1], "' must be equal when variable '", varnames[2], "' equals 0 or FALSE", sep="") )
	if ( any(!data[,v2] & data[,v4]) ) stop( paste("Variable '", varnames[4], "' must be equal to 0 or FALSE when variable '", varnames[2], "' equals 0 or FALSE", sep="") )
	if ( any(data[,v1] == data[,v3] & data[,v2] & !data[,v4]) ) stop( paste("When variables '", varnames[3], "' and '", varnames[1], "' are equal and variable '", varnames[2], "' equals 1 or TRUE, variable '", varnames[4], "' must equal 1 or TRUE", sep="") )
	return( data.frame("times1"=data[,v1], "delta"=as.integer(data[,v3] > data[,v1]), "times2"=(data[,v3]-data[,v1]), "time"=data[,v3], "status"=data[,v4], data[,-c(v1, v2, v3, v4)]) )
}
