\name{MenvU_sim}
\alias{MenvU_sim}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Generate sample estimator of \code{M} and \code{U}
}
\description{
This function is to generate sample estimator of \code{M} and \code{U}, which are the matrices in \code{M}-envelope of \code{U}.
}
\usage{
MenvU_sim(n, p, u, Omega=NULL, Omega0=NULL, Phi=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{Sample size.}
  \item{p}{Dimension of \code{M}.}
  \item{u}{Envelope dimension.}
  \item{Omega}{The positive definite matrix \eqn{\Omega} in \eqn{M=\Gamma\Omega\Gamma^T+\Gamma_0\Omega_0\Gamma_0^T}. The default is generated by \eqn{\Omega=AA^T} with the elements in \eqn{A} is generated from a standard uniform distribution.}
  \item{Omega0}{The positive definite matrix \eqn{\Omega_0} in \eqn{M=\Gamma\Omega\Gamma^T+\Gamma_0\Omega_0\Gamma_0^T}. The default is generated by \eqn{\Omega=AA^T} with the elements in \eqn{A} is generated from a standard uniform distribution.}
  \item{Phi}{The positive definite matrix \eqn{\Phi} in \eqn{U=\Gamma\Phi\Gamma^T}. The default is generated by \eqn{\Omega=AA^T} with the elements in \eqn{A} is generated from a standard uniform distribution.}
}

\value{
\item{Mhat}{Sample estimator of \code{M}.}
\item{Uhat}{Sample estimator of \code{U}.}
\item{Gamma}{Matrix \eqn{\Gamma} in generating \code{M} and \code{U}.}
}

\examples{
data <- MenvU_sim(n=200, p=20, u=5, Omega=NULL, Omega0=NULL, Phi=NULL)
Mhat <- data$Mhat
Uhat <- data$Uhat
}
