% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPRdim.R
\name{TPRdim}
\alias{TPRdim}
\title{Envelope dimension by cross-validation for tensor predictor regression (TPR).}
\usage{
TPRdim(x, y, maxdim = 10, nfolds = 5)
}
\arguments{
\item{x}{The predictor tensor instance of dimension \eqn{p_1\times p_2\times\cdots\times p_m \times n}, where \eqn{n} is the sample size. Array with the same dimensions and matrix with dimension \eqn{p\times n} are acceptable.}

\item{y}{The response matrix of dimension \eqn{r \times n}, where \eqn{n} is the sample size. Vector of length \eqn{n} is acceptable.}

\item{maxdim}{The largest dimension to be considered for selection.}

\item{nfolds}{Number of folds for cross-validation.}
}
\value{
\item{mincv}{The minimal cross-validation mean squared error.}
\item{u}{The envelope subspace dimension selected.}
}
\description{
Select the envelope dimension by cross-validation for tensor predictor regression.
}
\details{
According to Zhang and Li (2017), the dimensions of envelopes at each mode are assumed to be equal, so the \code{u} returned is a single value representing the equal envelope dimension.

For each dimension \code{u} in \code{1:maxdim}, we obtain the prediction
\deqn{\hat{Y}_i = \hat{B}_{(m+1)} vec(X_i)}
 for each predictor \eqn{X_i} in the \eqn{k}-th testing dataset, \eqn{k = 1,\ldots,}\code{nfolds}, where \eqn{\hat{B}} is the estimated coefficient based on the \eqn{k}-th training dataset. And the mean squared error for the \eqn{k}-th testing dataset is defined as
 \deqn{1/nk \sum_{i=1}^{nk}||Y_i-\hat{Y}_i||_F^2,}
where \eqn{nk} is the sample size of the \eqn{k}-th testing dataset and \eqn{||\cdot||_F} denotes the Frobenius norm. Then, the average of \code{nfolds} mean squared error is recorded as cross-validation mean squared error for the dimension \code{u}.
}
\examples{
# The dimension of predictor
p <- c(10, 10, 10)
# The envelope dimensions u.
u <- c(1, 1, 1)
# The dimension of response
r <- 5
# The sample size
n <- 200
dat <- TPRsim(p = p, r = r, u = u, n = n)
x <- dat$x
y <- dat$y
TPRdim(x, y, maxdim = 5)

## Use dataset square. (time-consuming)
\dontrun{
data("square")
x <- square$x
y <- square$y
# check the dimension of x
dim(x)
# use 32 as the maximal envelope dimension
TPRdim(x, y, maxdim=32)}

}
\references{
Zhang, X. and Li, L., 2017. Tensor envelope partial least-squares regression. Technometrics, 59(4), pp.426-436.
}
\seealso{
\code{\link{TPRsim}}.
}
