% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3D_NA.R
\name{plot3D_NA}
\alias{plot3D_NA}
\title{Visualize the Spatial Distribution of Missing Observations - 3D Map}
\usage{
plot3D_NA(newdata, xlab = NULL, ylab = NULL, zlab = NULL, title = NULL,
  cex = 3, color = "orange", colorNA = "blue")
}
\arguments{
\item{newdata}{data frame; should only contain the four variables in order: X coordinate, Y coordinate, Z coordinate
and observation. This is the cross-section data or pure spatial data of a particular time point you have selected,
with missing observations that you want to predict. (coordinates must be numeric)}

\item{xlab}{a label for the x axis, defaults to the name of X coordinate.}

\item{ylab}{a label for the y axis, defaults to the name of Y coordinate.}

\item{zlab}{a label for the z axis, defaults to the name of Z coordinate.}

\item{title}{a main title for the plot.}

\item{cex}{numeric; size of plotting point for each spatial location. (default: 3)}

\item{color}{colour to be used to fill the spatial locations. (default: "orange")}

\item{colorNA}{colour for denoting missing values/observations. (default: "blue")}
}
\description{
\code{plot3D_NA} shows spatial locations with or without missing observation. It is plotted based on
the cross-section data of a given time point, which is also often extracted from spatio-temporal data.
}
\details{
\itemize{
  \item The resulting plot is interactive.
  \item \code{plot3D_NA} is exclusive to 3D rectangular grid system. Similarly, if you want to fathom how
  this package handles 2D rectangular grid system, please refer to \code{plot_NA}.
}
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression3D(data = data, h1 = 3.75, h2 = 2.5, v = 5, alpha = 0.01);
basis$percentage
est <- tscsEstimate3D(matrix = basis$coef_matrix, newdata = newdata, h1 = 3.75, h2 = 2.5, v = 5);
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,4], true = true)
index <- appraisal_index(est = est$estimate[,4], true = true);
index

## data visualization:

plot3D_dif(data = data[,1:3], h1 = 3.75, h2 = 2.5, v = 5)
plot3D_NA(newdata = newdata)
plot3D_map(newdata = newdata)
}
}
\seealso{
\code{plot_NA}, \code{plot3D_map}, \code{plot3D_dif}
}
