% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3D_dif.R
\name{plot3D_dif}
\alias{plot3D_dif}
\title{Plot Interior Spatial Locations and System Boundary - 3D Map}
\usage{
plot3D_dif(coords, h1, h2, v, xlab = NULL, ylab = NULL, zlab = NULL,
  title = NULL, cex = 3)
}
\arguments{
\item{coords}{data frame; should only contain the three variables: X coordinate, Y coordinate and Z coordinate.
Each row uniquely denotes a spatial location. (coordinates must be numeric)}

\item{h1}{numeric; side length of the unit cubic grid in X coordinate direction (horizontal).}

\item{h2}{numeric; side length of the unit cubic grid in Y coordinate direction (horizontal).}

\item{v}{numeric; side length of the unit cubic grid in Z coordinate direction (vertical).}

\item{xlab}{a label for the x axis, defaults to the name of X coordinate.}

\item{ylab}{a label for the y axis, defaults to the name of Y coordinate.}

\item{zlab}{a label for the z axis, defaults to the name of Z coordinate.}

\item{title}{a main title for the plot.}

\item{cex}{numeric; size of point to be plotted for each spatial location. (default: 3)}
}
\description{
\code{plot3D_dif} differentiates boundary and interior spatial locations in a spatial domain (a collection of
spatial locations with their coordinates). Since TSCS method is only capable of interpolation but not
extrapolation, it is necessary to highlight the difference between interior spatial locations and system boundary.
}
\details{
\itemize{
  \item The resulting plot is interactive, where the red points are interior spatial locations
  while the black points denote system boundary.
  \item \code{plot3D_dif} is exclusive to 3D rectangular grid system. Similarly, if you want to fathom how
  this package handles 2D rectangular grid system, please refer to \code{plot_dif}.
}
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression3D(data = data, h1 = 3.75, h2 = 2.5, v = 5, alpha = 0.01);
basis$percentage
est <- tscsEstimate3D(matrix = basis$coef_matrix, newdata = newdata, h1 = 3.75, h2 = 2.5, v = 5);
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,4], true = true)
index <- appraisal_index(est = est$estimate[,4], true = true);
index

## data visualization:

plot3D_dif(data = data[,1:3], h1 = 3.75, h2 = 2.5, v = 5)
plot3D_NA(newdata = newdata)
plot3D_map(newdata = newdata)
}
}
\seealso{
\code{plot_dif}, \code{plot3D_NA}, \code{plot3D_map}
}
