% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_helper_functions.R
\name{get_y}
\alias{get_y}
\title{get_y}
\usage{
get_y(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{A data.frame containing in-bag or out-of-bag data}

\item{scoring_function_parameters}{A list of named elements containing control
parameters and other data required by the scoring function}
}
\value{
Response variable (if present) or NULL.
}
\description{
Returns the response variable in the in-bag or out-of-bag data.
}
\details{
If the user provides a y_var parameter in the list of
scoring_function_parameters this function will return the variable specified
by that parameter. If the user specifies a y_col parameter in the list of
scoring_function_parameters the function returns the column in data indexed
by that parameter. Lastly, if data contains a variable called 'y' that
variable is returned. Otherwise, NULL is returned.
}
\examples{
## Create an example data.frame
df <- data.frame( y <- 1:5 )
names( df ) <- "y"
df$time <- 10:14
df$time2 <- 20:24
df$event <- sample( c(0:1), size = 5, replace = TRUE )
df$trt <- sample( c("Control","Treatment"), size = 5, replace = TRUE )
df$x1 <- runif( n = 5 )
df$x2 <- LETTERS[1:5]

## Select the y variable by name
get_y( df, scoring_function_parameters = list( y_var = 'y' ) )

## Select the y variable by column index
get_y( df, scoring_function_parameters = list( y_col = 1 ) )

## The default behavior works for this example because the y variable in df
## is actually called y.
get_y( df )

## If the user's data does not contain a variable called
## 'y' the default behavior will fail. In this case the user must explicitly
## identify the 'y' variable via one of the two previous methods.
names( df )[which(names(df) == "y")] <- "response" # rename the 'y' variable to 'response'

get_y( df )  # now default behavior fails (i.e. returns NULL)

get_y( df, scoring_function_parameters = list( y_var = 'response' ) ) # this works
}
\seealso{
\link{get_trt}, \link{get_covariates}
}
