% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE.r, R/evaluating_subclasses.r
\name{MSE}
\alias{MSE}
\alias{NMSE_eval}
\alias{RMSE_eval}
\alias{MAPE_eval}
\alias{sMAPE_eval}
\alias{MAXError_eval}
\alias{AIC_eval}
\alias{BIC_eval}
\alias{AICc_eval}
\alias{LogLik_eval}
\title{MSE error of prediction}
\usage{
MSE(actual, prediction)

NMSE_eval(eval_par = list(train.actual = NULL))

RMSE_eval()

MAPE_eval()

sMAPE_eval()

MAXError_eval()

AIC_eval()

BIC_eval()

AICc_eval()

LogLik_eval()
}
\arguments{
\item{actual}{A vector or univariate time series containing actual values
for a time series that are to be compared against its respective
predictions.}

\item{prediction}{A vector or univariate time series containing time series
predictions that are to be compared against the values in \code{actual}.}

\item{eval_par}{List of named parameters required by \code{\link{NMSE}} such as \code{train.actual}.}
}
\value{
A numeric value of the MSE error of prediction.
}
\description{
The function calculates the MSE error between actual and predicted values.
}
\section{Error metrics}{

	Normalised Mean Squared Error.


	Root Mean Squared Error.


	Mean Absolute Percentage Error.


	Symmetric Mean Absolute Percentage Error.


	Maximal Error.
}

\section{Fitness criteria}{

	Akaike's Information Criterion.


	Schwarz's Bayesian Information Criterion.


	Second-order Akaike's Information Criterion.


	Log-Likelihood.
}

\examples{

data(SantaFe.A,SantaFe.A.cont)
pred <- marimapred(SantaFe.A,n.ahead=100)
MSE(SantaFe.A.cont[,1], pred)

}
\references{
Z. Chen and Y. Yang, 2004, Assessing forecast accuracy measures,
Preprint Series, n. 2004-2010, p. 2004-10.
}
\seealso{
\code{\link{NMSE}},\code{\link{MAPE}},\code{\link{sMAPE}},
\code{\link{MAXError}}
}
\author{
Rebecca Pontes Salles
}
\keyword{MSE}
\keyword{error}
\keyword{prediction}
