% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend.r
\name{detrend}
\alias{detrend}
\alias{detrend.rev}
\title{Detrending Transformation}
\usage{
detrend(x, trend)
}
\arguments{
\item{x}{A numeric vector or univariate time series of class \code{ts}.}

\item{trend}{A numeric vector or univariate time series containing the trend
to be removed. Generally, the fitted values of a model object.}
}
\value{
A vector of the same length as \code{x} containing the residuals of
\code{x} after trend removal.
}
\description{
The \code{detrend()} function performs a detrending transformation and
removes a trend from the provided time series. \code{detrend.rev()} reverses
the transformation.
}
\examples{

data(CATS,CATS.cont)
fpoly <- fittestPolyR(CATS[,1],h=20)
trend <- fitted(fpoly$model)

residuals <- detrend(CATS[,1],trend)
x <- detrend.rev(residuals,trend)

}
\references{
R. H. Shumway, D. S. Stoffer, Time Series Analysis and Its
Applications: With R Examples, Springer, New York, NY, 4 edition, 2017.
}
\seealso{
\code{\link{DIF}},\code{\link{BCT}}, \code{\link{MAS}},
\code{\link{LT}}, \code{\link{PCT}}
}
\author{
Rebecca Pontes Salles
}
\keyword{detrending}
\keyword{series}
\keyword{time}
\keyword{transform}
\keyword{trend}
