\name{diss.AR.MAH}
\alias{diss.AR.MAH}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Model-based Dissimilarity Proposed by Maharaj (1996, 2000)%%  ~~function to do ... ~~
}
\description{
Computes the dissimilarity between two time series by testing whether both series are or not generated by the same ARMA model.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
diss.AR.MAH(x, y, dependence=FALSE, permissive=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
   Numeric vector containing the first of the two time series.
%%     ~~Describe \code{x} here~~
}
  \item{y}{
  Numeric vector containing the second of the two time series.
%%     ~~Describe \code{y} here~~
}
  \item{dependence}{
  Boolean for considering dependence between observations of the series at the same point in time.
	}
  \item{permissive}{
  Boolean for continuing with the method even if no valid order is selected by AIC.
  }
	
}
\details{
Assuming that the time series x and y belong to the class of invertible and stationary ARMA processes, this dissimilarity measure is based on checking the equality of their underlying ARMA models by following the testing procedures proposed by Maharaj (1996,2000). The ARMA structures are approximated by truncated AR(\eqn{\infty}) models with a common order \eqn{k = \max{(k_x, k_y)}}, where \eqn{k_x} and \eqn{k_y} are determined by the AIC criterion. The AR coefficients are automatically fitted. The dissimilarity can be evaluated by using the value of the test statistic or alternatively the associated p-value. If \code{dependence} is \code{FALSE}, the dissimilarity measure is constructed by following the procedure introduced by Maharaj (1996), which is designed to compare independent time series. Otherwise, a more general testing procedure is used (Maharaj, 2000), which assumes that both models are correlated at the same time points but uncorrelated across observations (Maharaj, 2000).
When \code{permissive} argument is \code{TRUE}, if the automatic fitting of the AR order fails, the method shows a warning and then forces an AR of order 1. If \code{permissive} is \code{FALSE} the method produces an error if no AR order is found by AIC.

}
\value{
\item{statistic}{The statistic of the homogeneity test.}
\item{p_value}{The p-value of the homogeneity test.}

%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
Maharaj, E.A. (1996) A significance test for classifying {ARMA} models. \emph{J. Statist. Comput. Simulation}, \bold{54(4)}, 305--331.\cr

Maharaj E.A. (2000) Clusters of time series. \emph{J. Classification}, \bold{17(2)}, 297--314.

Montero, P and Vilar, J.A. (2014) \emph{TSclust: An R Package for Time Series Clustering.}  Journal of Statistical Software, 62(1), 1-43. \url{http://www.jstatsoft.org/v62/i01/.}

}
\author{
Pablo Montero Manso, José Antonio Vilar.
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
 \code{\link{diss.AR.PIC}},  \code{\link{diss.AR.LPC.CEPS}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
## Create three sample time series
x <- arima.sim(model=list(ar=c(0.4,-0.1)), n =100, n.start=100)
y <- arima.sim(model=list(ar=c(0.9)), n =100, n.start=100)
z <- arima.sim(model=list(ar=c(0.5, 0.2)), n =100, n.start=100)
## Compute the distance and check for coherent results
diss.AR.MAH(x, y)
diss.AR.MAH(x, z)
diss.AR.MAH(y, z)

#create a dist object for its use with clustering functions like pam or hclust
diss( rbind(x,y,z), "AR.MAH")$statistic

}

