% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAX.R
\name{repr_sax}
\alias{repr_sax}
\title{SAX - Symbolic Aggregate Approximation}
\usage{
repr_sax(x, q = 2, a = 6, eps = 0.01)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{q}{the integer of the length of the "piece" in PAA}

\item{a}{the integer of the alphabet size}

\item{eps}{is the minimum threshold for variance in x and should be a numeric value. If x has a smaller variance than eps, it will represented as a word using the middle alphabet.}
}
\value{
the character vector of SAX representation
}
\description{
The \code{repr_sax} creates SAX symbols for a univariate time series.
}
\examples{
x <- rnorm(48)
repr_sax(x, q = 4, a = 5)

}
\references{
Lin J, Keogh E, Lonardi S, Chiu B (2003)
A symbolic representation of time series, with implications for streaming algorithms.
Proceedings of the 8th ACM SIGMOD Workshop on Research Issues in Data Mining and Knowledge Discovery - DMKD'03
}
\seealso{
\code{\link[TSrepr]{repr_paa}, \link[TSrepr]{repr_pla}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
